/*
 * Decompiled with CFR 0.152.
 */
class SilhouetteList {
    protected link _head = null;
    protected link _tail = null;
    protected int _num = 0;
    protected static SilhouetteList _freelist = new SilhouetteList();

    public void add(Silhouette silhouette) {
        link link2 = this.makeNewLink(silhouette, null);
        this.add(link2);
    }

    public void add(SilhouetteList silhouetteList) {
        if (silhouetteList._num == 0) {
            return;
        }
        if (this._head != null) {
            this._tail._next = silhouetteList._head;
            this._tail = silhouetteList._tail;
            this._num += silhouetteList._num;
        } else {
            this._head = silhouetteList._head;
            this._tail = silhouetteList._tail;
            this._num = silhouetteList._num;
        }
    }

    protected void add(link link2) {
        link2._next = null;
        if (this._head == null) {
            this._head = this._tail = link2;
        } else {
            this._tail._next = link2;
            this._tail = link2;
        }
        ++this._num;
    }

    public void clear() {
        _freelist.add(this);
        this._head = null;
        this._tail = null;
        this._num = 0;
    }

    public Silhouette getFirst() {
        return (Silhouette)this._head._ob;
    }

    public link getFirstLink() {
        return this._head;
    }

    public Silhouette getLast() {
        return (Silhouette)this._tail._ob;
    }

    protected link makeNewLink(Silhouette silhouette, link link2) {
        link link3 = _freelist.removeFirstLink();
        if (link3 != null) {
            link3._ob = silhouette;
            link3._next = link2;
        } else {
            link3 = new link(silhouette, null);
        }
        return link3;
    }

    public int num() {
        return this._num;
    }

    public void prepend(Silhouette silhouette) {
        link link2 = this.makeNewLink(silhouette, null);
        this.prepend(link2);
    }

    public void prepend(SilhouetteList silhouetteList) {
        if (this._head != null) {
            silhouetteList._tail._next = this._head;
            this._head = silhouetteList._head;
            this._num += silhouetteList._num;
        } else {
            this._head = silhouetteList._head;
            this._tail = silhouetteList._tail;
            this._num = silhouetteList._num;
        }
    }

    protected void prepend(link link2) {
        link2._next = this._head;
        this._head = this._head == null ? (this._tail = link2) : link2;
        ++this._num;
    }

    public boolean remove(Silhouette silhouette) {
        if (this._num == 0) {
            return false;
        }
        link link2 = this._head;
        link link3 = null;
        while (!((Silhouette)link2._ob).equals(silhouette) && link2 != null) {
            link3 = link2;
            link2 = link2._next;
        }
        if (link2 == null) {
            return false;
        }
        if (link3 == null) {
            if (this._num > 1) {
                this._head = this._head._next;
                _freelist.add(link2);
                --this._num;
            } else {
                this.clear();
            }
        } else if (link2 == this._tail) {
            this._tail = link3;
            this._tail._next = null;
            _freelist.add(link2);
            --this._num;
        } else {
            link3._next = link2._next;
            _freelist.add(link2);
            --this._num;
        }
        return true;
    }

    protected link removeFirstLink() {
        if (this._num > 0) {
            link link2 = this._head;
            this._head = this._head._next;
            --this._num;
            return link2;
        }
        return null;
    }
}

