/*
 * Decompiled with CFR 0.152.
 */
import javax.vecmath.Point3d;

public class Point3dCache {
    Point3dList[] _cache = new Point3dList[this.CACHE_SIZE];
    int CACHE_SIZE = 100;
    double _interval;
    Point3dIterator _prox_iter;

    Point3dCache(double d) {
        int n = 0;
        while (n < this.CACHE_SIZE) {
            this._cache[n] = new Point3dList();
            ++n;
        }
        this._interval = d;
        this._prox_iter = new Point3dIterator(new Point3dList());
    }

    public void add(Point3dList point3dList) {
        Point3dIterator point3dIterator = new Point3dIterator(point3dList);
        point3dIterator.init();
        while (!point3dIterator.isDone()) {
            this.add(point3dIterator.curr());
            point3dIterator.incr();
        }
    }

    public void add(Point3d point3d) {
        this._cache[this.key(point3d)].add(point3d);
    }

    public void clear() {
        int n = 0;
        while (n < this.CACHE_SIZE) {
            this._cache[n].clear();
            ++n;
        }
    }

    protected int key(Point3d point3d) {
        int n = (int)Math.floor(1.0 / this._interval * point3d.x) % this.CACHE_SIZE;
        if (n < 0) {
            n += this.CACHE_SIZE;
        }
        return n;
    }

    public void print() {
        int n = 0;
        while (n < this.CACHE_SIZE) {
            System.out.println(this._cache[n].num());
            ++n;
        }
    }

    public boolean proximityTest(Point3d point3d) {
        int n = this.key(point3d);
        this._prox_iter.setList(this._cache[n]);
        this._prox_iter.init();
        while (!this._prox_iter.isDone()) {
            if (this._prox_iter.curr().distance(point3d) < this._interval) {
                return true;
            }
            this._prox_iter.incr();
        }
        int n2 = n - 1;
        if (n2 == -1) {
            n2 = this.CACHE_SIZE - 1;
        }
        this._prox_iter.setList(this._cache[n2]);
        this._prox_iter.init();
        while (!this._prox_iter.isDone()) {
            if (this._prox_iter.curr().distance(point3d) < this._interval) {
                return true;
            }
            this._prox_iter.incr();
        }
        int n3 = n + 1;
        if (n3 == this.CACHE_SIZE) {
            n3 = 0;
        }
        this._prox_iter.setList(this._cache[n3]);
        this._prox_iter.init();
        while (!this._prox_iter.isDone()) {
            if (this._prox_iter.curr().distance(point3d) < this._interval) {
                return true;
            }
            this._prox_iter.incr();
        }
        return false;
    }

    public void setInterval(double d) {
        this._interval = d;
        this.clear();
    }
}

