/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseEvent;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class Modeler {
    protected Intersector _i;
    protected Point3d _downpt;
    protected Point3d _lastpt;
    protected Point3d _currpt;
    protected Vector3d _planevec;
    protected Point3d _planept;
    protected boolean _mouse_dragged;
    protected BlobbyModel _model;
    protected ImplCanvas3D _canvas;

    public Modeler(BlobbyModel blobbyModel, ImplCanvas3D implCanvas3D) {
        this._model = blobbyModel;
        this._canvas = implCanvas3D;
        this._i = new Intersector();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this._mouse_dragged = true;
        if (this._downpt == null) {
            return;
        }
        Point3d point3d = new Point3d();
        this._canvas.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d);
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        Vector3d vector3d = new Vector3d(this._canvas.viewdir());
        vector3d.normalize();
        this._currpt = MathHelper.plane_intersect(point3d, vector3d, this._planept, this._planevec);
        if (this._currpt != null) {
            Vector3d vector3d2 = new Vector3d();
            vector3d2.sub((Tuple3d)this._currpt, (Tuple3d)this._lastpt);
            this._model.notify(vector3d2);
            this._lastpt = this._currpt;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point3d point3d = new Point3d();
        this._canvas.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d);
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        Vector3d vector3d = new Vector3d(this._canvas.viewdir());
        vector3d.normalize();
        this._lastpt = this._downpt = this._model.select(point3d, vector3d);
        if (this._downpt != null) {
            this._planevec = vector3d;
            this._planept = this._downpt;
        }
        this._mouse_dragged = false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this._mouse_dragged) {
            Point3d point3d = new Point3d();
            this._canvas.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d);
            Transform3D transform3D = new Transform3D();
            this._canvas.getImagePlateToVworld(transform3D);
            transform3D.transform(point3d);
            Vector3d vector3d = new Vector3d(this._canvas.viewdir());
            vector3d.normalize();
            Point3d point3d2 = MathHelper.plane_intersect(point3d, vector3d, new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0));
            this._model.click(point3d2, mouseEvent);
            System.out.println(String.valueOf(mouseEvent.isShiftDown()) + "   " + mouseEvent.isControlDown());
        }
    }

    public void setModel(BlobbyModel blobbyModel) {
        this._model = blobbyModel;
    }
}

