/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class Illus3D
extends Applet
implements AdjustmentListener,
ActionListener {
    private Frame _frame;
    private MyUniverseBuilder _universe_builder;
    private ImplCanvas3D _canvas;
    private EdgeFinder _edge_finder;
    private EdgeProcessor _edge_proc;
    private BlobbyFunction3D _func;
    private BlobbyModel _model;
    private Modeler _md;
    private ModelTracer _mt;
    private RayShooter _rs;
    private double _targetval;
    private BranchGroup _root;
    private BranchGroup _sphere_group;
    private BranchGroup _light_group;
    private BranchGroup _surface_group;
    private BranchGroup _silh_group;
    private BranchGroup _ground_plane;
    private Checkbox _auto_draw;
    private boolean _auto_switch;
    private Checkbox _show_lines;
    private boolean _line_switch;
    private Checkbox _show_points;
    private boolean _point_switch;
    private Checkbox _show_silh;
    private boolean _silh_switch;
    private Label _fps_label;
    private Scrollbar _fps_slider;
    private Label _res_label;
    private Scrollbar _res_slider;
    private FileDialog _loader;
    private FileDialog _saver;
    private TextField _target_box;
    private Label _blank;

    public Illus3D(String string, Frame frame) {
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._canvas = new ImplCanvas3D();
        this.add("Center", (Component)((Object)this._canvas));
        this._func = string != null && string != "" ? new BlobbyFunction3D(string) : new BlobbyFunction3D();
        this._targetval = this._func.getDefaultVal();
        this._mt = new ModelTracer(this._func);
        this._model = new BlobbyModel(this._func, this);
        this._universe_builder = new MyUniverseBuilder(this._canvas);
        this._canvas._cam = this._universe_builder.getCam();
        this._root = this.createScene();
        this._silh_group = new BranchGroup();
        this._silh_group.setCapability(14);
        this._silh_group.setCapability(12);
        this._silh_group.setCapability(13);
        this._silh_group.setCapability(17);
        this._root.addChild((Node)this._silh_group);
        this._mt._bg = this._silh_group;
        this._edge_finder = new EdgeFinder(this._func, this._universe_builder.getCam());
        this._edge_proc = new EdgeProcessor(this._func);
        this._edge_finder.setCanvas(this._canvas);
        this._edge_finder.setEdgeProcessor(this._edge_proc);
        this._edge_proc.setCanvas(this._canvas);
        this._edge_proc.setEdgeFinder(this._edge_finder);
        this._canvas.setEdgeProcessor(this._edge_proc);
        this._canvas.setEdgeFinder(this._edge_finder);
        this._canvas.setModel(this._model);
        this._canvas.setFunction(this._func);
        this._universe_builder.getCam().addCamListener(this._canvas);
        this._edge_finder._bg = this._silh_group;
        this._rs = new RayShooter(this._silh_group, this._universe_builder.getCam(), this._canvas, this._func);
        SearchGuide searchGuide = new SearchGuide(this._edge_finder);
        this._md = new Modeler(this._model, this._canvas);
        MouseInteractor mouseInteractor = new MouseInteractor(this._canvas, this._universe_builder.getCam(), this._rs, searchGuide, this._md);
        this._root.setCapability(14);
        this._root.setCapability(12);
        this._root.setCapability(13);
        this._universe_builder.addBranchGraph(this._root);
        MouseBehavior mouseBehavior = new MouseBehavior();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        mouseBehavior.setSchedulingBounds((Bounds)boundingSphere);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)mouseBehavior);
        this._root.addChild((Node)branchGroup);
        Panel panel = new Panel();
        if (this._frame != null) {
            panel.setLayout(new GridLayout(2, 6));
        } else {
            panel.setLayout(new GridLayout(2, 5));
        }
        this._auto_draw = new Checkbox("Auto-Draw", true);
        this._auto_switch = true;
        panel.add(this._auto_draw);
        this._fps_label = new Label("FPS 5");
        panel.add(this._fps_label);
        this._fps_slider = new Scrollbar(0, 5, 3, 1, 30);
        this._fps_slider.addAdjustmentListener(this);
        panel.add(this._fps_slider);
        this._target_box = new TextField(String.valueOf(this._func.getDefaultVal()));
        this._target_box.addActionListener(this);
        panel.add(this._target_box);
        this._line_switch = false;
        if (this._frame != null) {
            panel.add(new Button("Load"));
        }
        panel.add(new Button("Clear"));
        this._show_points = new Checkbox("Edit", false);
        this._point_switch = false;
        panel.add(this._show_points);
        this._res_label = new Label("Resolution");
        panel.add(this._res_label);
        this._res_slider = new Scrollbar(0, 0, 3, -10, 13);
        this._res_slider.addAdjustmentListener(this);
        panel.add(this._res_slider);
        this._blank = new Label("");
        panel.add(this._blank);
        this._silh_switch = true;
        if (this._frame != null) {
            panel.add(new Button("Save"));
        }
        panel.add(new Button("Quit"));
        this.add("South", panel);
        this._loader = new FileDialog(this._frame, "Load Model", 0);
        this._loader.setDirectory(".");
        this._saver = new FileDialog(this._frame, "Save Model", 1);
        this._saver.setDirectory(".");
        this._edge_finder.start();
        this._edge_proc.start();
    }

    public boolean action(Event event, Object object) {
        if (object.equals("Quit")) {
            System.exit(0);
            return true;
        }
        if (object.equals("Clear")) {
            int n = this._silh_group.numChildren() - 1;
            while (n >= 0) {
                this._silh_group.removeChild(n);
                --n;
            }
            this._rs.clearCache();
            return true;
        }
        if (object.equals("Shoot")) {
            this._rs.shootRays();
            return true;
        }
        if (object.equals("Randomize")) {
            BlobIterator blobIterator = new BlobIterator(this._func.getList());
            blobIterator.init();
            while (!blobIterator.isDone()) {
                double d = Math.random() * 4.0 - 2.0;
                double d2 = Math.random() * 4.0 - 2.0;
                double d3 = Math.random() * 4.0 - 2.0;
                System.out.println("New X: " + d);
                blobIterator.curr()._point.set(d, d2, d3);
                blobIterator.incr();
            }
            if (this._point_switch) {
                this._sphere_group.detach();
                this._ground_plane.detach();
            }
            this.updateDisplay();
            this._sphere_group = this._model.makeBranchGroup();
            this._sphere_group.setCapability(17);
            if (this._point_switch) {
                this._root.addChild((Node)this._sphere_group);
                this._root.addChild((Node)this._ground_plane);
            }
            return true;
        }
        if (object.equals("Load")) {
            this._loader.show();
            String string = this._loader.getFile();
            if (string == null) {
                return true;
            }
            BlobbyFunction3D blobbyFunction3D = new BlobbyFunction3D();
            if (blobbyFunction3D.read(string)) {
                System.out.println("!@#$%" + blobbyFunction3D.eval(new Point3d()));
                this.setFunc(blobbyFunction3D);
            }
            return true;
        }
        if (object.equals("Save")) {
            this._saver.show();
            String string = this._saver.getFile();
            if (string == null) {
                return true;
            }
            System.out.println("Saving as " + string);
            if (this._func instanceof BlobbyFunction3D) {
                this._func.setDefaultVal(this._targetval);
                this._func.write(string);
            }
            return true;
        }
        if (event.target.equals(this._auto_draw)) {
            this._auto_switch ^= true;
            this._canvas.setDrawingEnabled(this._auto_switch);
            return true;
        }
        if (event.target.equals(this._show_lines)) {
            this._line_switch ^= true;
            if (!this._line_switch) {
                this._surface_group.detach();
            } else {
                this._root.addChild((Node)this._surface_group);
            }
            return true;
        }
        if (event.target.equals(this._show_points)) {
            this._point_switch ^= true;
            if (!this._point_switch) {
                this._sphere_group.detach();
                this._ground_plane.detach();
                this._canvas.showModel(false);
            } else {
                this._root.addChild((Node)this._sphere_group);
                this._root.addChild((Node)this._ground_plane);
                this._canvas.showModel(true);
            }
            return true;
        }
        if (event.target.equals(this._show_silh)) {
            this._silh_switch ^= true;
            if (!this._silh_switch) {
                this._silh_group.detach();
            } else {
                this._root.addChild((Node)this._silh_group);
            }
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println(actionEvent.getActionCommand());
        try {
            double d = Double.valueOf(actionEvent.getActionCommand());
            this._canvas.updateTargetVal(d);
            this._targetval = d;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public Background addBackground() {
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)boundingSphere);
        return background;
    }

    public BranchGroup addLights() {
        BranchGroup branchGroup = new BranchGroup();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f color3f = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f color3f2 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f vector3f = new Vector3f(-0.5f, -0.5f, -1.0f);
        AmbientLight ambientLight = new AmbientLight(color3f);
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)ambientLight);
        DirectionalLight directionalLight = new DirectionalLight(color3f2, vector3f);
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)directionalLight);
        return branchGroup;
    }

    public BranchGroup addRefGeometry() {
        BranchGroup branchGroup = new BranchGroup();
        Color3f color3f = new Color3f(0.0f, 0.5f, 0.0f);
        LineArray lineArray = new LineArray(44, 5);
        int n = 0;
        while (n < 22) {
            lineArray.setCoordinate(n, new Point3d((double)(-5 + n / 2), 0.0, -5.0));
            lineArray.setCoordinate(n + 1, new Point3d((double)(-5 + n / 2), 0.0, 5.0));
            lineArray.setColor(n, color3f);
            lineArray.setColor(n + 1, color3f);
            n += 2;
        }
        int n2 = 22;
        while (n2 < 44) {
            lineArray.setCoordinate(n2, new Point3d(-5.0, 0.0, (double)((n2 - 22) / 2 - 5)));
            lineArray.setCoordinate(n2 + 1, new Point3d(5.0, 0.0, (double)((n2 - 22) / 2 - 5)));
            lineArray.setColor(n2, color3f);
            lineArray.setColor(n2 + 1, color3f);
            n2 += 2;
        }
        branchGroup.addChild((Node)new Shape3D((Geometry)lineArray, new Appearance()));
        return branchGroup;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this._fps_slider) {
            this._canvas.requestFramesPerSecond(this._fps_slider.getValue());
            this._fps_label.setText("FPS" + Integer.toString(this._fps_slider.getValue()));
        } else if (adjustmentEvent.getAdjustable() == this._res_slider) {
            this._edge_finder.setEps(Math.pow(1.15, this._res_slider.getValue()));
            this._edge_finder.intervalSizeChanged();
        }
    }

    public BranchGroup createScene() {
        BranchGroup branchGroup = new BranchGroup();
        this._sphere_group = this._model.makeBranchGroup();
        this._light_group = this.addLights();
        this._sphere_group.addChild((Node)this._light_group);
        this._surface_group = new BranchGroup();
        Background background = this.addBackground();
        this._ground_plane = this.addRefGeometry();
        this._ground_plane.setCapability(17);
        branchGroup.addChild((Node)background);
        this._sphere_group.setCapability(17);
        this._surface_group.setCapability(17);
        return branchGroup;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            System.exit(0);
            return true;
        }
        return super.handleEvent(event);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Illus3D illus3D = stringArray.length > 0 ? new Illus3D(stringArray[0], frame) : new Illus3D("", frame);
        frame.add(illus3D);
        frame.resize(512, 512);
        frame.show();
    }

    public void setFunc(Function3D function3D) {
        this._func = (BlobbyFunction3D)function3D;
        this._mt.setFunc(function3D);
        this._targetval = this._func.getDefaultVal();
        this._model = new BlobbyModel(this._func, this);
        this._md.setModel(this._model);
        if (this._point_switch) {
            this._sphere_group.detach();
            this._ground_plane.detach();
        }
        this._sphere_group = this._model.makeBranchGroup();
        this._sphere_group.setCapability(17);
        if (this._point_switch) {
            this._root.addChild((Node)this._sphere_group);
            this._root.addChild((Node)this._ground_plane);
        }
        this._canvas.distributeFunc(function3D, this._model);
    }

    public void updateDisplay() {
        this._edge_finder.camChanged(true);
        this._edge_proc.clear();
    }
}

