/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class BlobbyFunction3D
extends Function3D {
    private BlobList _list;
    private double _slope_highbound;
    private BlobIterator _grad_iter;
    private BlobIterator _hess_iter;

    public BlobbyFunction3D() {
        this._list = new BlobList();
        this._default_val = 1.0;
        this.initIterators();
        this.computeSlopeBound();
    }

    public BlobbyFunction3D(BlobList blobList) {
        this._list = blobList;
        this._default_val = 1.0;
        this.initIterators();
        this.computeSlopeBound();
    }

    public BlobbyFunction3D(BlobList blobList, double d) {
        this._list = blobList;
        this._default_val = d;
        this.initIterators();
        this.computeSlopeBound();
    }

    public BlobbyFunction3D(String string) {
        this.read(string);
        this.initIterators();
        this.computeSlopeBound();
    }

    protected void computeSlopeBound() {
        this._slope_highbound = 0.0;
        BlobIterator blobIterator = new BlobIterator(this._list);
        blobIterator.init();
        while (!blobIterator.isDone()) {
            this._slope_highbound += blobIterator.curr()._rad;
            blobIterator.incr();
        }
        if (this._slope_highbound < 0.0) {
            this._slope_highbound *= -1.0;
        }
    }

    public double eval(Point3d point3d) {
        double d = 0.0;
        BlobIterator blobIterator = new BlobIterator(this._list);
        blobIterator.init();
        while (!blobIterator.isDone()) {
            d += blobIterator.curr()._rad / (1.0 + point3d.distanceSquared(blobIterator.curr()._point));
            blobIterator.incr();
        }
        return d;
    }

    public BlobList getList() {
        return this._list;
    }

    public void gradient(Point3d point3d, Vector3d vector3d) {
        Point3d point3d2 = point3d;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this._grad_iter.init();
        while (!this._grad_iter.isDone()) {
            double d4 = Math.pow(1.0 + point3d2.distanceSquared(this._grad_iter.curr()._point), 2.0);
            double d5 = this._grad_iter.curr()._rad;
            d += -2.0 * d5 * (point3d2.x - this._grad_iter.curr()._point.x) / d4;
            d2 += -2.0 * d5 * (point3d2.y - this._grad_iter.curr()._point.y) / d4;
            d3 += -2.0 * d5 * (point3d2.z - this._grad_iter.curr()._point.z) / d4;
            this._grad_iter.incr();
        }
        vector3d.set(d, d2, d3);
    }

    public void hessian(Point3d point3d, Matrix3d matrix3d) {
        Point3d point3d2 = point3d;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        this._hess_iter.init();
        while (!this._hess_iter.isDone()) {
            double d7 = this._hess_iter.curr()._rad;
            double d8 = 1.0 + point3d2.distanceSquared(this._hess_iter.curr()._point);
            double d9 = Math.pow(d8, 3.0);
            double d10 = -2.0 * d7 / Math.pow(d8, 2.0);
            double d11 = point3d2.x - this._hess_iter.curr()._point.x;
            double d12 = point3d2.y - this._hess_iter.curr()._point.y;
            double d13 = point3d2.z - this._hess_iter.curr()._point.z;
            d6 += 8.0 * d11 * d11 * d7 / d9 + d10;
            d5 += 8.0 * d11 * d12 * d7 / d9;
            d4 += 8.0 * d11 * d13 * d7 / d9;
            d3 += 8.0 * d12 * d12 * d7 / d9 + d10;
            d2 += 8.0 * d12 * d13 * d7 / d9;
            d += 8.0 * d13 * d13 * d7 / d9 + d10;
            this._hess_iter.incr();
        }
        matrix3d.setRow(0, d6, d5, d4);
        matrix3d.setRow(1, d5, d3, d2);
        matrix3d.setRow(2, d4, d2, d);
    }

    private void initIterators() {
        this._grad_iter = new BlobIterator(this._list);
        this._hess_iter = new BlobIterator(this._list);
    }

    public static void main(String[] stringArray) {
        BlobList blobList = new BlobList();
        blobList.add(new Blob(new Point3d(-1.521224, -1.107608, 0.23512), 1.0));
        blobList.add(new Blob(new Point3d(1.06163, -0.968311, 0.6057), 1.0));
        blobList.add(new Blob(new Point3d(0.214358, 1.53239, 1.939333), -0.5));
        BlobbyFunction3D blobbyFunction3D = new BlobbyFunction3D(blobList);
        blobbyFunction3D.setDefaultVal(1.2);
        blobbyFunction3D.write("test2.blob");
        blobbyFunction3D.read("test2.blob");
        System.out.println("def: " + blobbyFunction3D.getDefaultVal());
        BlobIterator blobIterator = new BlobIterator(blobbyFunction3D.getList());
        blobIterator.init();
        while (!blobIterator.isDone()) {
            System.out.println(String.valueOf(String.valueOf(blobIterator.curr()._point)) + "  " + blobIterator.curr()._rad);
            blobIterator.incr();
        }
    }

    public boolean read(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file " + string);
            return false;
        }
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        this._list = new BlobList();
        try {
            this._default_val = dataInputStream.readDouble();
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                double d = dataInputStream.readDouble();
                double d2 = dataInputStream.readDouble();
                double d3 = dataInputStream.readDouble();
                double d4 = dataInputStream.readDouble();
                this._list.add(new Blob(new Point3d(d, d2, d3), d4));
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + string);
            return false;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error closing file " + string);
            return false;
        }
        this.initIterators();
        return true;
    }

    public void setList(BlobList blobList) {
        this._list = blobList;
        this._grad_iter.setList(this._list);
        this._hess_iter.setList(this._list);
    }

    public double slopeHighBound() {
        return this._slope_highbound;
    }

    public double slopeLowBound() {
        return -this._slope_highbound;
    }

    public boolean write(String string) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file " + string);
            return false;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        try {
            dataOutputStream.writeDouble(this._default_val);
            dataOutputStream.writeInt(this._list.num());
            BlobIterator blobIterator = new BlobIterator(this._list);
            blobIterator.init();
            while (!blobIterator.isDone()) {
                dataOutputStream.writeDouble(blobIterator.curr()._point.x);
                dataOutputStream.writeDouble(blobIterator.curr()._point.y);
                dataOutputStream.writeDouble(blobIterator.curr()._point.z);
                dataOutputStream.writeDouble(blobIterator.curr()._rad);
                blobIterator.incr();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error writing to file " + string);
            return false;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error closing file " + string);
            return false;
        }
        return true;
    }
}

