\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cs1515}[2025/01/20 cs1515 Handout Class]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Meta

% Koma document class with parskip
\LoadClass[parskip]{scrartcl}

% Custom title
\RequirePackage{titling}
\setlength{\droptitle}{-2.5cm}

\pretitle{\begin{center}\sffamily\bfseries\LARGE}

\preauthor{}
\postauthor{}

\predate{}
\postdate{}

\posttitle{\vspace{-1em} \end{center}}

% margins
% \usepackage[
%             % a4paper,
%             % bindingoffset=0.2in,
%             % left=1in,
%             % right=1in,
%             % top=1in,
%             % bottom=1in,
%             % footskip=.25in
%             ]{geometry}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other

% color
\usepackage{xcolor}

% math
\usepackage{amsmath}

% symbols
\usepackage{amssymb}

% folders, directories, and shell commands
\usepackage{menukeys}
\renewmenumacro{\directory}{pathswithfolder}

\usepackage{newverbs}
\newverbcommand{\bverb}
  {\begin{lrbox}{\verbbox}}
  {\end{lrbox}\colorbox{gray!30}{\box\verbbox}}

% links
\usepackage{hyperref}
\hypersetup{
    colorlinks=true,
    linkcolor=blue,
    filecolor=magenta,      
    urlcolor=blue,
    pdftitle={\@title},
    pdfpagemode=FullScreen,
    }

% images
\newcommand{\Graphic}[2]{
    \begin{center}
        \includegraphics[width=#2\textwidth]{#1}
    \end{center}
}

% to format blocks of code
\usepackage{listings}
\definecolor{listinggray}{gray}{0.9}
\definecolor{lbcolor}{rgb}{0.9,0.9,0.9}
\definecolor{darkgreen}{rgb}{0,0.4,0}
\lstset{
    backgroundcolor=\color{lbcolor},
    tabsize=4,    
%   rulecolor=,
    language=[GNU]C++,
        basicstyle=\scriptsize,
        upquote=true,
        aboveskip={1.5\baselineskip},
        columns=fixed,
        showstringspaces=false,
        extendedchars=false,
        breaklines=true,
        prebreak = \raisebox{0ex}[0ex][0ex]{\ensuremath{\hookleftarrow}},
        frame=single,
        numbers=left,
        showtabs=false,
        showspaces=false,
        showstringspaces=false,
        identifierstyle=\ttfamily,
        keywordstyle=\color[rgb]{0,0,1},
        commentstyle=\color[rgb]{0.026,0.112,0.095},
        stringstyle=\color[rgb]{0.627,0.126,0.941},
        numberstyle=\color[rgb]{0.205, 0.142, 0.73},
%        \lstdefinestyle{C++}{language=C++,style=numbers}’.
}
\lstset{
    backgroundcolor=\color{lbcolor},
    tabsize=4,
  language=C++,
  captionpos=b,
  tabsize=3,
  frame=lines,
  numbers=left,
  numberstyle=\tiny,
  numbersep=5pt,
  breaklines=true,
  showstringspaces=false,
  basicstyle=\footnotesize,
%  identifierstyle=\color{magenta},
  keywordstyle=\color[rgb]{0,0,1},
  commentstyle=\color{darkgreen},
  stringstyle=\color{red}
}
\lstset{basicstyle=\ttfamily,
  showstringspaces=false,
  commentstyle=\color{red},
  keywordstyle=\color{blue}
}

% TOC
\setcounter{tocdepth}{2} % don't show subsubsections

% definitions, theorems, lemmas, etc.
\usepackage{amsthm}

\newtheorem{defn}{Definition}
\newtheorem*{defn*}{Definition}
\newtheorem{thm}{Theorem}
\newtheorem*{thm*}{Theorem}
\newtheorem{lem}{Lemma}
\newtheorem*{lem*}{Lemma}