#ifndef __SHIP_H__
#define __SHIP_H__

#define SHIP_DENSITY_ADD 200.0
#define SHIP_SPRITE_WIDTH 64
#define SHIP_SPRITE_HEIGHT 64
// #define DAMAGE_FACTOR 0.0005
#define DAMAGE_FACTOR 0.001
#define MAX_SHIP_HEALTH 100.0
#define SHIELD_SPRITE_WIDTH 100
#define SHIELD_SPRITE_HEIGHT 100
#define MAX_SHIELD_RADIUS 50
#define MIN_SHIELD_RADIUS 30

#include "entity.h"
#include "missile.h"
#include "mine.h"

#include <set>

using namespace std;

class Ship : public Entity {
public:
	Ship();
	Ship(CFDSolver* cfd, COLOR color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem);
	virtual ~Ship();
	virtual void takeDamage(float dmg, int dt);
	virtual void update(int dt, bool* keys, CFDSolver* cfd);
	virtual void detonate();
	
	Missile* m_missile;
	Mine* m_mine;
	ITexture* m_shield;
	float m_health;
	int m_mineReloadCounter, m_missileReloadCounter;
	bool m_exploded;
	int m_explodeTime;
	float m_lastDamage;
	static const float m_weight = 0.01;
	static const float m_maxSpeed = 1.0;
	static const int m_reloadTime = 300;
	core::rect<s32> m_shieldDisplayRect;
	FMOD::Sound* m_alarm1, * m_alarm2;
	typedef pair<int,int> CoordPair;
	typedef set<CoordPair> CoordSet;
	CoordSet m_gridCells;
private:

};
#endif
