#ifndef __MISSILE_H__
#define __MISSILE_H__

#define MISSILE_SPRITE_WIDTH 64
#define MISSILE_SPRITE_HEIGHT 64
#define MISSILE_FLUID_PUSH_FACTOR 30.0
#define MISSILE_FLUID_THRUST_FACTOR -200.0
#define MISSILE_DENSITY_ADD 75.0


#include "entity.h"

class Missile : public Entity {
public:
	Missile();
	Missile(CFDSolver* cfd, COLOR color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem);
	virtual ~Missile();
	virtual void update(int dt, bool* keys, CFDSolver* cfd);
	virtual void activate(int rotDegrees, vector2df velocity, position2df position);
	virtual void detonate();

	bool m_active;
	int m_timePassed;
	static const float m_weight = 0.0005;
	static const float m_maxSpeed = 3.0;
	static const int m_beforeThrust = 300; //Time before thrust starts
	static const int m_beforeDetonate = 500; //Minimum time before detonating
	static const int m_thrustStops = 2000;
	static const int m_autoDetonate = 3000;
private:

};
#endif
