#ifndef __MINE_H__
#define __MINE_H__

#define MINE_SPRITE_WIDTH 30
#define MINE_SPRITE_HEIGHT 30
#define MINE_FLUID_PUSH_FACTOR 30.0
#define MINE_FLUID_THRUST_FACTOR -200.0
#define MINE_DENSITY_ADD 100.0

#include "entity.h"

class Mine : public Entity {
public:
	Mine();
	Mine(CFDSolver* cfd, COLOR color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem);
	virtual ~Mine();
	virtual void rotate(int degrees);
	virtual void update(int dt, bool* keys, CFDSolver* cfd);
	virtual void detonate();
	virtual void activate(int rotDegrees, vector2df velocity, position2df position);

	bool m_active;
	int m_timePassed;
	static const float m_weight = 0.0005;
	static const float m_velocityDamp = 0.95;
	static const float m_beforeDetonate = 500; //Time before detonating
	static const float m_autoDetonate = 3000;
private:

};
#endif
