#include "ship.h"
#include "mine.h"
#include <iostream>

Mine::Mine() {}

Mine::Mine(CFDSolver* cfd, COLOR color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem) :
	Entity(cfd, color, start, rotDegrees, driver, player, fmodSystem),
	m_active(false),
	m_timePassed(0) {
	
	stringc filename;
	switch (color) {
	case COLOR_RED:
		filename = "gfx/mine_red.png";
		break;
	case COLOR_GREEN:
		filename = "gfx/mine_green.png";
		break;
	case COLOR_BLUE:
		filename = "gfx/mine_blue.png";
		break;
	case COLOR_BLACK:
		filename = "gfx/mine_black.png";
		break;
	}
	m_texture = driver->getTexture(filename.c_str());
	m_displayRect = rect<s32>(0, 0, MINE_SPRITE_WIDTH, MINE_SPRITE_HEIGHT);
	//Initialize sounds
	errcheck(m_fmodSystem->createSound("sfx/mine_explode.wav", FMOD_LOOP_OFF|FMOD_2D|FMOD_SOFTWARE,0,&m_explodeSound));
	errcheck(m_fmodSystem->createSound("sfx/mine_launch.wav", FMOD_LOOP_OFF|FMOD_2D|FMOD_SOFTWARE,0,&m_launchSound));
}

Mine::~Mine() {
}

void Mine::rotate(int degrees) {
}

void Mine::update(int dt, bool* keys, CFDSolver* cfd) {
	m_timePassed += dt;
	// get point for CFD effects
	int cfdX = ((int) ((m_position.X)// + MISSILE_SPRITE_WIDTH / 2)
			* GRID_SIZE / SCREEN_WIDTH)) % GRID_SIZE;
	int cfdY = ((int) ((m_position.Y)// + MISSILE_SPRITE_HEIGHT / 2)
			* GRID_SIZE / SCREEN_HEIGHT)) % GRID_SIZE;

	if (m_timePassed > m_autoDetonate)
		detonate();
	// timestep
	if (dt) {
		// update position
		m_position.X += m_velocity.X * (float)dt;
		m_position.Y += m_velocity.Y * (float)dt;
	
		// damp velocity
		m_velocity *= m_velocityDamp;
	
		// torus wrap position
		if(m_position.X > SCREEN_WIDTH)
			m_position.X -= SCREEN_WIDTH;
		else if(m_position.X < 0)
			m_position.X += SCREEN_WIDTH;
		if(m_position.Y > SCREEN_HEIGHT)
			m_position.Y -= SCREEN_HEIGHT;
		else if(m_position.Y < 0)
			m_position.Y += SCREEN_HEIGHT;
	
		// push fluid out of the way
		cfd->addUForce(FLUID_PUSH_FACTOR*m_velocity.X, cfdX, cfdY);
		cfd->addVForce(FLUID_PUSH_FACTOR*m_velocity.Y, cfdX, cfdY);
	}
}

void Mine::activate(int rotDegrees, vector2df velocity, position2df position) {
	errcheck(m_fmodSystem->playSound(FMOD_CHANNEL_FREE, m_launchSound, false, NULL));
	m_active = true;
	m_position = position;
	m_rotation = rotDegrees;
	vector2df tmp(sin(TORADIANS(rotDegrees)),-1.0*cos(TORADIANS(rotDegrees)));
	m_velocity = velocity - tmp * 0.1;
	m_timePassed = 0;
}

void Mine::detonate() {
	if (m_timePassed < m_beforeDetonate)
		return;
	m_active = false;
	m_timePassed = 0;
	int cfdX = ((int) ((m_position.X + MINE_SPRITE_WIDTH / 2)
			* GRID_SIZE / SCREEN_WIDTH)) % GRID_SIZE;
	int cfdY = ((int) ((m_position.Y + MINE_SPRITE_HEIGHT / 2)
			* GRID_SIZE / SCREEN_HEIGHT)) % GRID_SIZE;
	m_cfd->addDensityAt(MINE_DENSITY_ADD, cfdX, cfdY);
	errcheck(m_fmodSystem->playSound(FMOD_CHANNEL_FREE, m_explodeSound, false, NULL));
}
