#!/usr/bin/perl -w
use strict;

while (my $file = shift) {
	my $fileNoExt = $file;
	$fileNoExt =~ s/\..*$//;
	print "Operating on $fileNoExt\n";

	for (my $i = 0; $i < 360; $i += 5) {
		my $fileNo = $i / 5;
		my $newFile = $fileNoExt . "_" . $fileNo . ".png";
		`convert -background 'none' -rotate $i $file $newFile`;
		my $id = `identify $newFile`;
		print $id;
		my $size = $id;
		$size =~ /^.*?(\d\d)x/;
		$size = $1;
		my $diff = ($size - 64) / 2;
		my $diffStr = $diff . "x" . $diff;
		`convert -shave $diffStr $newFile $newFile`;
	}
}
