#ifndef __ENTITY_H__
#define __ENTITY_H__

#define TORADIANS(x) (x*M_PI/180.0)
#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#define MIN(a, b) (((a) < (b)) ? (a) : (b))

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define GRID_SIZE 96
#define MAX_VELOCITY 1.0
#define FLUID_PUSH_FACTOR 200.0
#define FLUID_THRUST_FACTOR -500.0
#define FLASH_TIME_SLOW 1000
#define FLASH_TIME_FAST 500
#define FLASH_HP_SLOW 0.4
#define FLASH_HP_FAST 0.2

#include <irrlicht.h>
#include <math.h>
#include "CFDSolver.h"
#include <fmod.hpp>
#include <fmod_errors.h>

using namespace irr;
using namespace core;
using namespace video;
enum COLOR {
	COLOR_RED,
	COLOR_GREEN,
	COLOR_BLUE,
	COLOR_BLACK,
	COLOR_NONE
};

inline void errcheck(FMOD_RESULT result) {
	if (result != FMOD_OK) {
		fprintf(stderr, "FMOD error! (%d) %s\n", result, FMOD_ErrorString(result));
		exit(-1);
	}
}

class Entity {
public:
	Entity();
	Entity(CFDSolver* cfd, COLOR  color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem);
	virtual ~Entity();
	virtual bool applyForce(vector2df accel, float weight, int dt);
	virtual void applyThrust(int cfdX, int cfdY, CFDSolver* cfd);
	virtual void rotate(int degrees);
	virtual void update(int dt, bool* keys, CFDSolver* cfd) = 0;
	virtual void detonate() = 0;
	
	position2df m_position;
	int m_rotation;
	IVideoDriver* m_driver;
	CFDSolver* m_cfd;
	int m_player;
	vector2df m_velocity;
	FMOD::System* m_fmodSystem;
	FMOD::Channel* m_thrustChannel;
	FMOD::Sound* m_thrustSound;
	FMOD::Sound* m_explodeSound;
	FMOD::Sound* m_launchSound;
	ITexture* m_texture;
	ITexture* m_textureArray[72];
	ITexture* m_textureThrustArray[72];
	static const float m_weight = 0.01;
	static const float m_maxSpeed = 1.0;
	static const float m_velocityDamp = 0.99;
	rect<s32> m_displayRect;
	EKEY_CODE* m_keymap;
private:

};
#endif
