#include "entity.h"
#include <iostream>

Entity::Entity() {}

Entity::Entity(CFDSolver* cfd, COLOR color, position2df start, int rotDegrees, IVideoDriver* driver, int player, FMOD::System* fmodSystem) :
m_position(start),
m_rotation(rotDegrees),
m_driver(driver),
m_cfd(cfd),
m_player(player),
m_velocity(vector2df(0.0, 0.0)),
m_fmodSystem(fmodSystem) {
}

Entity::~Entity() {}

bool Entity::applyForce(vector2df accel, float weight, int dt) {
	if (dt) {
		// Update velocity and store it in new_vel
		vector2df new_vel;
		new_vel.X = m_velocity.X + accel.X * weight * (float)dt;
		new_vel.Y = m_velocity.Y + accel.Y * weight * (float)dt;

		if(new_vel.getLength() <= MAX_VELOCITY) { // If new_vel isn't too fast, then update real velocity
			m_velocity.X = new_vel.X;
			m_velocity.Y = new_vel.Y;
			return true;
		} else {				  // max velocity reached
			return false;
		}
	}
	return false;
}

void Entity::applyThrust(int cfdX, int cfdY, CFDSolver* cfd) {
	// apply force
	bool applied = applyForce(vector2df(sin(TORADIANS(m_rotation)),
			     	       -1.0*cos(TORADIANS(m_rotation))), m_weight, 1);
	// if force was applied, apply it to CFD
	if(applied) {
		vector2df dir = vector2df(sin(TORADIANS(m_rotation)),
					-1.0*cos(TORADIANS(m_rotation)));
		cfd->addUForce(FLUID_THRUST_FACTOR * dir.X, cfdX, cfdY);
		cfd->addVForce(FLUID_THRUST_FACTOR * dir.Y, cfdX, cfdY);
	}
	//Change the sprite
	m_texture = m_textureThrustArray[m_rotation/5];
}

void Entity::rotate(int degrees) {//, int dt) {
	m_rotation += degrees;// / dt;
	if (m_rotation >= 360) 
		m_rotation -= 360;
	if (m_rotation < 0)
		m_rotation += 360;
	m_texture = m_textureArray[m_rotation/5];
}


