#ifndef CFDSOLVER_H_
#define CFDSOLVER_H_

class CFDSolver
{
public:
	CFDSolver(int N, float dt, float diffusion, float viscosity);
	virtual ~CFDSolver();
	
	float getDensityAt(int x, int y);
	float getUAt(int x, int y);
	float getVAt(int x, int y);
	void addDensityAt(float source, int x, int y);
	void addUForce(float force, int x, int y);
	void addVForce(float force, int x, int y);
	void runTimeStep(float dt=0);
	void vel_step (float * u, float * v, float * u0, float * v0);
	void dens_step (float * x, float * x0, float * u, float * v);
	void remove_from_all (float dt);
	void clearAll();
	
private:
	//methods
	void advect (int b, float * d, float * d0, float * u, float * v);
	void diffuse (int b, float * x, float * x0, float diff);
	void lin_solve (int b, float * x, float * x0, float a, float c );
	void project (float * u, float * v, float * p, float * div );
	void set_bnd (int b, float * x );
	//helper method
	float* newClean(int length);

	//variables
	float* m_density, *m_dens_prev;
	float* m_vecu, *m_vecu_prev;
	float* m_vecv, *m_vecv_prev;
	float m_dt;//timestep length
	float m_diff;//diffusion rate
	float m_visc;//viscosity rate
	int m_N;//number of squares on a side
	int m_size;//total number of squares...should be (N+2)^2
};

#endif /*CFDSOLVER_H_*/
