/*
 * Decompiled with CFR 0.152.
 */
package xml2csvconv;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    String source;
    String result;
    String emptyValue = "-";
    String separator = ",";
    String loopFieldName;
    boolean distinct;
    HashSet<String> keepOnlyFieldsNames = new HashSet();
    HashSet<String> ignoreFieldsNames = new HashSet();
    Map<String, String> fields = new TreeMap<String, String>();
    Map<String, String> values = new TreeMap<String, String>();
    Set<Integer> previousValues = new HashSet<Integer>();
    Map<String, Integer> levels = new TreeMap<String, Integer>();
    Map<String, String> loopFields = new TreeMap<String, String>();
    Map<String, Integer> loops = new TreeMap<String, Integer>();
    boolean gotFirstElement;

    public void setSource(String source) {
        this.source = source;
    }

    public void setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setIgnoreFieldsNames(HashSet<String> ignoreFieldsNames) {
        this.ignoreFieldsNames = ignoreFieldsNames;
    }

    public void setKeepFieldsNames(HashSet<String> keepFieldsNames) {
        this.keepOnlyFieldsNames = keepFieldsNames;
    }

    public void setLoopFieldName(String loopFieldName) {
        this.loopFieldName = loopFieldName;
    }

    public String getSource() {
        return this.source;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public HashSet<String> getIgnoreFieldsNames() {
        return this.ignoreFieldsNames;
    }

    public HashSet<String> getKeepFieldsNames() {
        return this.keepOnlyFieldsNames;
    }

    public String getLoopFieldName() {
        return this.loopFieldName;
    }

    public String getResult() {
        return this.result;
    }

    public Main(String source) {
        this(source, null, null, null, false);
    }

    public Main(String source, String loopFieldName) {
        this(source, loopFieldName, null, null, false);
    }

    public Main(String source, String loopFieldName, HashSet<String> keepOnlyFieldsNames, HashSet<String> ignoreFieldsNames, boolean distinct) {
        this(source, loopFieldName, keepOnlyFieldsNames, ignoreFieldsNames, distinct, null, null);
    }

    public Main(String source, boolean distinct, String emptyValue, String separator) {
        this(source, null, null, null, distinct, emptyValue, separator);
    }

    public Main(String source, String loopFieldName, HashSet<String> keepOnlyFieldsNames, HashSet<String> ignoreFieldsNames, boolean distinct, String emptyValue, String separator) {
        this.source = source;
        this.loopFieldName = loopFieldName;
        if (keepOnlyFieldsNames != null) {
            this.keepOnlyFieldsNames.addAll(keepOnlyFieldsNames);
        }
        if (ignoreFieldsNames != null) {
            this.ignoreFieldsNames.addAll(ignoreFieldsNames);
        }
        this.distinct = distinct;
        if (emptyValue != null) {
            this.emptyValue = emptyValue;
        }
        if (separator != null) {
            this.separator = separator;
        }
    }

    public String convert() throws ParserConfigurationException, SAXException, IOException {
        this.fields.clear();
        this.levels.clear();
        this.values.clear();
        this.previousValues.clear();
        this.gotFirstElement = false;
        this.result = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document root = builder.parse(this.source);
        this.parseFields(root, 0);
        if (this.loopFieldName == null) {
            this.determineLoopFieldName();
        }
        this.parseValues(root, 0);
        if (this.gotFirstElement) {
            this.printMapToResult(this.values);
        }
        return this.result;
    }

    void parseFields(Node node, int level) {
        this.addToLoopFields(level, node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                this.addToFields(level, node.getNodeName(), attribute.getNodeName());
            }
        }
        boolean hastext = false;
        boolean haselement = false;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                haselement = true;
                this.parseFields(child, level + 1);
                continue;
            }
            if (!child.getNodeName().equals("#text") || child.getNodeValue().trim().isEmpty()) continue;
            hastext = true;
        }
        if (!haselement && hastext) {
            this.addToFields(level, node.getNodeName());
        }
    }

    void parseValues(Node node, int level) {
        if (node.getNodeName().equals(this.loopFieldName)) {
            if (this.gotFirstElement) {
                this.printMapToResult(this.values);
                this.resetValuesInRow(level);
            } else {
                this.printMapToResult(this.fields);
                this.gotFirstElement = true;
            }
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                this.addToValues(attribute.getNodeValue(), level, node.getNodeName(), attribute.getNodeName());
            }
        }
        boolean hastext = false;
        boolean haselement = false;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                haselement = true;
                this.parseValues(child, level + 1);
                continue;
            }
            if (!child.getNodeName().equals("#text") || child.getNodeValue().trim().isEmpty()) continue;
            hastext = true;
        }
        if (!haselement && hastext) {
            this.addToValues(node.getFirstChild().getNodeValue(), level, node.getNodeName());
        }
    }

    void determineLoopFieldName() {
        int max = 0;
        String maxField = null;
        for (String key : this.loopFields.keySet()) {
            if (this.loops.get(key) > max) {
                max = this.loops.get(key);
                maxField = this.loopFields.get(key);
            }
            if (max < 2) continue;
            break;
        }
        this.loopFieldName = maxField;
    }

    void addToFields(int level, String nodeName) {
        this.addToFields(level, nodeName, "");
    }

    void addToFields(int level, String nodeName, String argName) {
        if (!this.keepOnlyFieldsNames.isEmpty() ? !this.keepOnlyFieldsNames.contains(nodeName) : this.ignoreFieldsNames.contains(nodeName)) {
            return;
        }
        String key = this.makeKey(level, nodeName, argName);
        String name = this.makeKey(null, nodeName, argName);
        this.fields.put(key, name);
        this.values.put(key, this.emptyValue);
        this.levels.put(key, level);
    }

    void addToLoopFields(int level, String nodeName) {
        String key = this.makeKey(level, nodeName, null);
        String name = this.makeKey(null, nodeName, null);
        this.loopFields.put(key, name);
        Integer loop = this.loops.get(key);
        if (loop == null) {
            loop = 0;
        }
        this.loops.put(key, loop + 1);
    }

    void addToValues(String value, int level, String nodeName) {
        this.addToValues(value, level, nodeName, null);
    }

    void addToValues(String value, int level, String nodeName, String argName) {
        String key = this.makeKey(level, nodeName, argName);
        if (this.fields.containsKey(key)) {
            this.values.put(key, value);
        }
    }

    String makeKey(Integer level, String nodeName, String argName) {
        String ret = "";
        if (level != null) {
            ret = ret + level + ":";
        }
        ret = ret + nodeName;
        if (argName != null && !argName.isEmpty()) {
            ret = ret + " [" + argName + "]";
        }
        return ret;
    }

    void resetValuesInRow(int level) {
        for (String i : this.levels.keySet()) {
            if (this.levels.get(i) < level) continue;
            this.values.put(i, this.emptyValue);
        }
    }

    void printMapToResult(Map<String, String> map) {
        if (this.distinct) {
            if (this.previousValues.contains(((Object)map).hashCode())) {
                return;
            }
            this.previousValues.add(((Object)map).hashCode());
        }
        Iterator<String> iter = map.values().iterator();
        while (iter.hasNext()) {
            this.result = this.result + iter.next().replace(this.separator, " ");
            if (!iter.hasNext()) continue;
            this.result = this.result + this.separator;
        }
        this.result = this.result + System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        int i;
        String loop = null;
        HashSet<String> keep = new HashSet<String>();
        HashSet<String> ignore = new HashSet<String>();
        boolean distinct = false;
        String empty = null;
        String separator = null;
        HashSet<String> optionsWithArgument = new HashSet<String>();
        optionsWithArgument.add("-l");
        optionsWithArgument.add("-k");
        optionsWithArgument.add("-i");
        optionsWithArgument.add("-e");
        optionsWithArgument.add("-s");
        HashSet<String> options = new HashSet<String>();
        options.addAll(optionsWithArgument);
        options.add("-d");
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            String nextArg = "";
            if (i + 1 < args.length) {
                nextArg = args[i + 1];
            }
            if (optionsWithArgument.contains(arg.toLowerCase()) && (nextArg.isEmpty() || options.contains(nextArg.toLowerCase()))) {
                Main.printHelp();
                return;
            }
            if (arg.equals("-l")) {
                loop = nextArg.trim();
                ++i;
                continue;
            }
            if (arg.equals("-k") || arg.equals("-i")) {
                String[] fields;
                for (String field : fields = nextArg.split(",")) {
                    field = field.trim();
                    if (arg.equals("-k")) {
                        keep.add(field);
                        continue;
                    }
                    ignore.add(field);
                }
                ++i;
                continue;
            }
            if (arg.equals("-d")) {
                distinct = true;
                continue;
            }
            if (arg.equals("-e")) {
                empty = nextArg;
                ++i;
                continue;
            }
            if (!arg.equals("-s")) break;
            separator = nextArg;
            ++i;
        }
        if (i + 2 != args.length) {
            Main.printHelp();
            return;
        }
        String source = args[i];
        String destination = args[i + 1];
        if (source.charAt(0) == '-' || destination.charAt(0) == '-') {
            Main.printHelp();
            return;
        }
        Main main = new Main(source, loop, keep, ignore, distinct, empty, separator);
        try {
            main.convert();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage() + "!");
            return;
        }
        try {
            PrintWriter out = new PrintWriter(destination);
            out.print(main.result);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error: " + e.getMessage() + "!");
            return;
        }
        System.out.println("Data was successful converted!");
    }

    public static void printHelp() {
        System.out.println("Syntax error!");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("    xml2csv-conv [-options] <source filename or url> <destination filename>");
        System.out.println("");
        System.out.println("Options");
        System.out.println("    -l <field name>                 Allows to set the name of the field that");
        System.out.println("                                    repeats in XML schema.");
        System.out.println("    -k <list of fields' names>      Field' names that will be kept,");
        System.out.println("                                    separated by comma without space.");
        System.out.println("    -i <list of fields' names>      Field' names that will be ignored,");
        System.out.println("                                    separated by comma without space.");
        System.out.println("    -d                              Returns not duplicated rows.");
        System.out.println("    -e <value>                      Value for empty data, e.g. \"-\"");
        System.out.println("    -s <value>                      Value for separator in CSV, e.g. \",\"");
        System.out.println("");
        System.out.println("Usage examples:");
        System.out.println("    xml2csv-conv -l field -i city,country -d -s \",\" data.xml data.csv");
        System.out.println("    xml2csv-conv -k \"name, surname\" data.xml data.csv");
        System.out.println("    xml2csv-conv http://www.example.com/data.xml data.csv");
        System.out.println("    xml2csv-conv data.xml data.csv");
    }
}

