public class RoundRecords {
    /*
        This class shows a record-based implementation of tournament
        rounds, using null to indicate that we're at the start of the
        contest
     */

    record Round(Round leftContest, Round rightContest, String winner) {}

    /**
     * @param flavor -- the flavor to look for
     * @param contest -- the contest in which to search
     * @return how many times the given flavor won a round in the contest
     */
    public static int roundsWon(String flavor, Round contest) {
        if (contest == null)
            return 0;
        else if (contest.winner.equals(flavor)) {
            return 1 +
                    roundsWon(flavor, contest.leftContest()) +
                    roundsWon(flavor, contest.rightContest());
        } else {
            return roundsWon(flavor, contest.leftContest()) +
                    roundsWon(flavor, contest.rightContest());
        }
    }

    public static void main(String[] args) {
        // show how to define a round in records
        Round contest = new Round(
                new Round(
                        new Round(null, null, "cookiedough"),
                        new Round(null, null, "chocolate"),
                        "cookiedough"), // middle round winner
                new Round(
                        new Round(null, null, "lemon"),
                        new Round(null, null, "strawberry"),
                        "strawberry"),  // middle round winner
                "cookiedough"); // last round winner

        // running the records version of roundsWon
        System.out.println(roundsWon("cookiedough", contest));
    }

}
