public class Round implements IRound {
    String winner;      // the winner between flavor1 and flavor 2
    IRound leftContest;  // flavor1 won this round
    IRound rightContest; // flavor2 won this round

    public Round(String w, IRound left, IRound right) {
        this.winner = w;
        this.leftContest = left;
        this.rightContest = right;
    }

    public static void main(String[] args) {
        Round yellowRoundNull =
                  new Round("cookiedough",
                        new Round("cookiedough",
                            new Round("cookiedough", null, null),
                            new Round("chocolate", null, null)),
                        new Round("strawberry",
                            new Round("strawberry", null, null),
                            new Round("lemon", null, null)));
        Round yellowRoundInit =
                new Round("cookiedough",
                        new Round("cookiedough",
                                new InitRound("cookiedough"),
                                new InitRound("chocolate")),
                        new Round("strawberry",
                                new InitRound("strawberry"),
                                new InitRound("lemon")));

        System.out.println(yellowRoundNull.roundsWon("cd"));
        System.out.println(yellowRoundInit.roundsWon("cd"));
    }

    // write a method that counts how many rounds a given flavor won
    // this is the clean recursive version
    public int roundsWon(String flavor) {
        if (this.winner.equals(flavor))
            return 1 +
                    this.leftContest.roundsWon(flavor) +
                    this.rightContest.roundsWon(flavor);
        else
            return this.leftContest.roundsWon(flavor) +
                   this.rightContest.roundsWon(flavor);
    }

    // this is one version that checks for left/right contests being null
    // (compared to Null2 below, interleaves handling left and right)
    public int roundsWonNull1(String flavor) {
        if (this.winner.equals(flavor)) {
            if (this.leftContest != null) {
                if (this.rightContest != null)
                    return 1 +
                            this.leftContest.roundsWon(flavor) +
                            this.rightContest.roundsWon(flavor);
                else
                    return 1 + this.leftContest.roundsWon(flavor);
            } else {
                if (this.rightContest != null)
                    return 1 + this.rightContest.roundsWon(flavor);
                else return 0;
            }

        }
        else // would need to repeat all the null logic here
            return this.leftContest.roundsWon(flavor) +
                    this.rightContest.roundsWon(flavor);
    }

    // this is a tighter version that checks for left/right being null
    // (compared to Null1, it handles left/right separately from each other)
    public int roundsWonNull2(String flavor) {
        int leftCount = 0;
        int rightCount = 0;
        if (this.leftContest != null)
            leftCount = this.leftContest.roundsWon(flavor);
        if (this.rightContest != null)
            rightCount = this.rightContest.roundsWon(flavor);
        if (this.winner.equals(flavor))
            return 1 + leftCount + rightCount;
        else return leftCount + rightCount;
    }
}

