#pragma once
#include <list>

// horrendous hack to make std::list less retarded (size() now constant time)
template<class _Tp, class _Alloc = std::allocator<_Tp> >
class llist: public std::list<_Tp, _Alloc>
{
	private:
		size_t _size;

	public:
		llist(): _size(0) {}

		typedef typename std::list<_Tp, _Alloc>::iterator iterator;
		typedef typename std::list<_Tp, _Alloc>::value_type value_type;

		size_t size() { return _size; }

		iterator insert(iterator __position, const _Tp& __x) { _size++; return std::list<_Tp, _Alloc>::insert(__position, __x); }
		iterator erase(iterator __position) { _size--; return std::list<_Tp, _Alloc>::erase(__position); }

		void push_front(const value_type& x) { insert(begin(), x); }
		void push_back(const value_type& x) { insert(end(), x); }

		void pop_front() { erase(begin()); }
		void pop_back() { erase(--end()); }

		void clear() { std::list<_Tp, _Alloc>::clear(); _size = 0; }

};