#pragma once
#include "dojo/dojo.h"

namespace dojo {

class PullPoint : public Entity {
private:

	PullPoint(const std::string& name, Entity::Part* l);
	float pullForce;
	float speed, timeStep;
	Vector3 velocity, shift;
	bool limbLock;
	bool inPosition;
	bool move;
	Vector3 destination;

public:

	Entity::Part* limb;

	static EntityRef create(const std::string& name, Entity::Part* l) {
        static ArticulatedModelRef body = ArticulatedModel::fromFile("icosa.ifs", 1.0f/12.0f);
        static bool initialized = false;

        if (! initialized) {
            SuperShader::Material material;
			material.diffuse.constant = Color3::black() / 2;
            //material.diffuse.map   = Texture::fromFile("basketball.jpg");
            
            material.emit      = Color3::black();
            material.transmit  = Color3::black();
            material.reflect   = Color3::black();
            material.specular  = Color3::white() * .5f;
            material.specularExponent = Color3::white() * 40;

            body->partArray.last().triListArray[0].material = material;
            body->updateAll();
            initialized = true;
        }

        PullPoint* c = new PullPoint(name, l);

		c->addGraphicsGeometry("Root", body);

        // Note that the mass is not being transformed with the collision geometry!
		/*
        c->addPhysicsGeometry(
            "Root",
            new SphereShape(Sphere(Vector3::zero(), 1.0f/3.0f)),
            30);
			*/
            
        return EntityRef(c);
    }

	virtual void onSimulation(G3D::SimTime ts);

	void moveTo(const Vector3 dest);

	void initPosition();
	void attackForce();
	void limpForce(void);
	void toggleLock();
	void setSpeed(float s);
	bool isInPosition();
	void setVelocity(Vector3 v);
};
}