#pragma once

#include "Configuration.h"
#include "PullPoint.h"

using namespace dojo;
class Move
{
public:
	Move(const char* name, int id);
public:
	virtual ~Move(void);

	void addConfiguration(Configuration* c);
	void deleteConfiguration(int index);
	int deleteCurrentConfiguration();
	void setConfiguration(int index, Configuration* c);
	void setCurrentConfiguration(Configuration *c);
	void selectConfiguration(int index);

	Configuration* getCurrentConfiguration(void);
	Configuration* getConfiguration(int index);

	void setAttackLimb(PullPoint* limb);
	void setTarget(Entity::Part* t);
	void setTargetName(std::string name);

	PullPoint* getAttackLimb(void);
	Entity::Part* getTarget(void);
	std::string getTargetName(void);

	void activate(void);
	void reset(void);
	bool isActive(void);
	Configuration* nextPose(void);
	char* name(void);
	int numPoses(void);
	bool inConfiguration(void);

	bool strike(void);
	bool isStriking(void);

	int getId(void);

private:
	PullPoint *attackLimb;
	Entity::Part *target;
	char* m_name;
	std::string targetName;
	Array<Configuration*> poses;

	int currPose, moveId;
	bool active;
	bool struck;
	
};