#pragma once
#include "dojo/dojo.h"
#include "PullPoint.h"
#include "Configuration.h"
#include "Move.h"
#include <string>
#include <iostream>
#include <map>

using namespace dojo;
class Demo;

class Marionette : public StickFigure {

private:

	Demo *applet;
	Array<PullPoint*> strings; // the pull points
	Array<Configuration*> configs;
	int ppIndex;
	int configIndex;

	Array<Move*> allMoves;
	Array<char* > allNames;
	Move* currentMove;
	int selectedPose;
	float elapsedTime;
	float downTime, recovery, strike;

	bool doMove;
	bool touchingGround, wasTouchingGround;
	int playerNumber;
	int maxMoveId;
	Marionette *opponent;
	Configuration* defaultStance;

	typedef std::map<int, Move*> mmap;
	typedef mmap::iterator p_iter;
	mmap moveMap;

	Marionette(const std::string& name, int pnum, Demo* d);

public:

	void setOpponent(Marionette* opp);
	virtual ~Marionette(void);

    static EntityRef create(const std::string& name, int pnum, Demo* d) {
		return EntityRef(new Marionette(name, pnum, d));
    }

	virtual void onSimulation(G3D::SimTime ts);

	void initPullPoints(const CoordinateFrame& wsC);
	void setFrame(const CoordinateFrame& wsC);

	PullPoint* nextPullPoint(void);
	void setPullPoint(int index);

	void cycleConfiguration();
	void saveConfiguration();

	Array<char* > loadMoves(int pid);
	void saveMoves(int pid);
	void deleteMove(int sel);
	
	void setPose();

	void playMove();
	void playMove(int index);
	int moveCount(void);
	bool isMoving(void);

	void applyConfiguration(Configuration* pose);
	void setDefaultConfiguration(Configuration* pose);
	void setConfiguration();

	int addMove(char* name);
	int addMove(Move* m);

	void setMoveTarget(Entity::Part* target);
	void setAttackLimb(PullPoint* pullpoint);

	int addConfiguration(void);

	Move* selectMove(int index);
	Configuration* selectConfiguration(int index);

	Array<PullPoint*> getStrings(void);
	Entity::Part* hackPart(const std::string &partName);
	int deleteConfiguration();
	void realese(bool fall);

	void stopMoving(void);

	virtual bool onCollision(const std::string &myPart, const dojo::EntityRef &other, const std::string &otherPart, const Vector3 &wsLocation);

	void turnTo(CoordinateFrame cf);
	bool isAttacking(void);

	Configuration* getDefaultConfiguration(void);
	Array<std::string> getPartNames(void);
	void resetStrike(void);

	void clearMoves(void);

	Move* getMoveById(int id);
};
