#pragma once
#include "AI_Globals.h"
#include "AI_Player.h"
#include "AI_QValues.h"
#include "AI_SearchHeuristic.h"
#include "AI_StateInspector.h"

class GameData;

class LogicPlayer
{
public:
	LogicPlayer(GameData* data, int pnum);
	~LogicPlayer();

	void load(PLAYER_ID pid);
	void save() {}
	void clear();

public:
	// basic info
	GameData* _data;
	PLAYER_ID pid;
	int _pnum;

	// AI vars
	AI_StateInspector* _state_inspector;
	AI_QValues* _qvalues;
	AI_Player* _ai_player;
	AI_SearchHeuristic* _search_heuristic;
	AI_History* _history;
	std::vector<MOVE_ID> _moves;
	
	// AI parameters
	double _lr;
	double _dr;
	double _lambda;
	int _H;
	
	// Physics data
	PhysicsPlayer* _physics_player;
};
