#ifndef GUIAPP_H
#define GUIAPP_H

#pragma once
#include "wxGWindow.h"
#include "App.h"
#include "Demo.h"



// Frame for main app
class GUIFrame: public wxFrame {
public:
    GUIFrame(wxFrame* frame, const wxString& title, const wxPoint& pos,
            const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);

    wxStatusBar*    statusBar;
    wxSlider*       timeSlider;

	wxSlider*		xaxis;
	wxSlider*		yaxis;
	wxSlider*		zaxis;

	Demo*			applet;
	GUIPackage*		pack;

public:
	wxGWindow*		gwindow;
    wxPanel*		g3dPanel;
	
	//Drop down list of all joints
	wxChoice*		jointList;

	//List of all moves
	wxListBox*		moveList;

	//Add move controls
    wxTextCtrl*		moveName;
	wxButton*		addMoveButton;
	wxButton*		deleteMoveButton;
	wxButton*		playMoveButton;

	//List of available poses
	wxListBox*		poseList;
	wxButton*		addPoseButton;
	wxButton*		deletePoseButton;
	wxButton*		setPoseButton;

	wxChoice*		limbList;
	wxChoice*		targetList;

	wxListBox*		playerList;
	wxButton*		savePlayersButton;
	wxButton*		newPlayerButton;
	wxButton*		resetButton;
	wxTextCtrl*		playerName;


	// Event handlers
    void OnClose(wxCloseEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnFileMenuExit(wxCommandEvent& event);

	void OnJointSelect(wxCommandEvent& evt);

	void OnXSlider(wxScrollEvent& evt);
	void OnYSlider(wxScrollEvent& evt);
	void OnZSlider(wxScrollEvent& evt);

	void selectMove(wxCommandEvent& evt);
	void addNewMove(wxCommandEvent& evt);
	void deleteMove(wxCommandEvent& evt);
	void playMove(wxCommandEvent& evt);

	void selectPose(wxCommandEvent& evt);
	void setPose(wxCommandEvent& evt);
	void addNewPose(wxCommandEvent& evt);
	void deletePose(wxCommandEvent& evt);

	void selectAttack(wxCommandEvent& evt);
	void selectTarget(wxCommandEvent& evt);

	void OnReset(wxCommandEvent& evt);
	void OnSelectPlayer(wxCommandEvent& evt);
	void OnSavePlayers(wxCommandEvent& evt);
	void OnNewPlayer(wxCommandEvent& evt);

	static void addItem(char* item);

    DECLARE_EVENT_TABLE();
};

enum {
    // menu items
    FILEMENU_EXIT = 100
};


class GUIApp : public wxApp {

private:

    GUIFrame*        frame;

public:
	class App*			 app;

    bool OnInit(void);
};

#endif