#pragma once
#include "dojo/dojo.h"
#include "ui/ui.h"
#include "Marionette.h"
#include "Ball.h"
#include "GUIApp.h"
#include "GUIPackage.h"
#include "PullPoint.h"
#include <map>

using namespace dojo;

class Demo : public DApplet {
public:
	
	//Package of all gui objects that can be manipulated
	GUIPackage*			guiPackage;

	//the main player in the game.  In this case, a ball
    EntityRef           player;
	EntityRef			enemy;

	//Manipulation indicators and controls
	PullPoint*			currentPullPoint;
	Array<EntityRef>	markers;
	Array<bool>			selected;
	Array<PullPoint*>	strings;
	Array<Vector3>		relativeCenter;


	Marionette*			mario;
	Marionette*			luigi;

    // Add state that should be visible to this applet.
    // If you have multiple applets that need to share
    // state, put it in the App.

    TextureRef          logo;

    class App*          app;

	//the position in the worlds to spawn the player
	Vector3				spawnPosition;

	//used to record the position of the player in the previous frame.  used to
	//calculate camera position
	Vector3				previousPlayerPosition;

	//pointer to a GameUI to allow for UI Sprites, text etc.
	GameUI*				gameUI;

	//handle to the score text in the GameUI
	UIHandle			scoreHandle;
	UIHandle			deathHandle;
	UIHandle			hitHandle;
	int					hitObject;
	int					playerId;
	int					playerCount;

	typedef std::map<int, std::string> pmap;
	typedef pmap::iterator p_iter;
	pmap playerMap;


	//counter of the current score
	int gameScore;
	
	//counter of the current lives
	int gameLives;

	//pureDeltaMouse is a bool signifying if the camera is in mouse look mode
	bool pureDeltaMouse;

	bool dead;

	bool win;
	bool left_foot;

	float death_depth;

	//methods to change the score and the life count
	void setGameLives(int amt){gameLives = amt;}
	void incrementGameLives(int amt){gameLives += amt;}
	
	void setGameScore(int amt){
		if (!win) {
		gameScore = amt;
		}
	}

	void incrementGameScore(int amt){gameScore += amt;}
	void setDeathDepth(float depth){death_depth = depth;}

	
	Demo(App* app, GUIPackage* gpack);

    virtual ~Demo() {}

    virtual void onInit();

    virtual void onLogic();

    virtual void onUserInput(UserInput*);

	virtual void onNetwork();

    virtual void onSimulation(RealTime rdt, SimTime sdt, SimTime idt);

    virtual void onGraphics(RenderDevice* rd);

    virtual void onCleanup();

	virtual void playerDeath();

	virtual void endGameWin();

	void selectJoint(int sel);

	void setMove(int selection);
	void addMove(char* name);
	void deleteMove(int sel);

	void addPose();
	void selectPose(int selection);
	void setPose();

	void playMove();
	void deletePose(void);

	void setAttackLimb(int selection);
	void setTarget(std::string name);

	void loadPlayers(void);
	void reload(void);
	void selectPlayer(int id);
	void newPlayer(void);
	void savePlayers(void);
};