#include "Configuration.h"
#include "Marionette.h"

namespace dojo {

	// Need to use setPositions if your going to use this constructor
	Configuration::Configuration(Marionette* fighter_) 
	{
		fighter = fighter_;
	}

	Configuration::Configuration(G3D::Array<PullPoint*> pullPoints, Marionette* fighter_) {
		fighter = fighter_;
		for(int i = 0; i < pullPoints.size(); ++i) {
			positions.append(fighter->frame().pointToObjectSpace(pullPoints[i]->frame().translation));
		}
	}

	void Configuration::applyConfiguration(G3D::Array<PullPoint*> pullPoints) {
		for (int i = 0; i < positions.size(); i++) {
			pullPoints[i]->moveTo(fighter->frame().pointToWorldSpace(positions[i]));
		}
	}

	// Positions should be in the object coordinate system
	void Configuration::setPositions(G3D::Array<Vector3> poss) 
	{
		for (int i = 0; i < poss.size(); i++) {
			positions.append(poss[i]);
		}
	}

	Array<Vector3> Configuration::getPositions(void)
	{
		return positions;
	}

	bool Configuration::inPosition(void)
	{
		for (int i = 0; i < positions.size(); i++) {
			PullPoint* pp = fighter->getStrings()[i];
			if (!pp->isInPosition()) {
				return false;
			}
		}
		return true;
	}

	void Configuration::printInfo(void)
	{
		printf("%d \n", positions.size());

		for(int i = 0; i < positions.size(); i++)
		{
			printf("%f %f %f \n", positions[i].x,
				positions[i].y,
				positions[i].z);
		}
	}
}