#pragma once
#include "dojo/dojo.h"

using namespace dojo;

class Ball : public Entity {
private:

    Ball(const std::string& name) : Entity(name, "Root", false) {}

public:

    static EntityRef create(const std::string& name) {
        static ArticulatedModelRef body = ArticulatedModel::fromFile("icosa.ifs", 1.0f/10.0f);
        static bool initialized = false;

        if (! initialized) {
            SuperShader::Material material;
			material.diffuse.constant = Color3::yellow() / 2;
            //material.diffuse.map   = Texture::fromFile("basketball.jpg");
            
            material.emit      = Color3::black();
            material.transmit  = Color3::black();
            material.reflect   = Color3::black();
            material.specular  = Color3::white() * .5f;
            material.specularExponent = Color3::white() * 40;

            body->partArray.last().triListArray[0].material = material;
            body->updateAll();
            initialized = true;
        }

        Ball* c = new Ball(name);

        c->addGraphicsGeometry("Root", body);

        // Note that the mass is not being transformed with the collision geometry!
		/*
        c->addPhysicsGeometry(
            "Root",
            new SphereShape(Sphere(Vector3::zero(), 1.0f/3.0f)),
            30);
			*/
            
        return EntityRef(c);
    }
};