#pragma once
#include "AI_QValues.h"
#include "LogicPlayer.h"


class AI_Tree: public AI_QValues
{
public:
	AI_Tree(LogicPlayer* player) : AI_QValues(qv_standard), _player(player), _root(0) {}
	~AI_Tree() { clear(); }

	MQV_Map& get_qvalues();
	void update_qvalue(const AI_State& state, MOVE_ID move, double q);
	void load(PLAYER_ID pid);
	void save(PLAYER_ID pid);
	void clear();

	struct AI_Tree_Node;
	typedef std::map<int, AI_Tree_Node*> tn_map;
	typedef tn_map::iterator tn_iter;

	struct AI_Tree_Node
	{
		AI_Tree_Node(AI_Tree_Node* p, STATE_VAR_ID sid) : parent(p), branch_var(sid), num_visits(0) { }

		STATE_VAR_ID branch_var;
		MQV_Map mqv_map;
		int num_visits;
		AI_Tree_Node* parent;
		tn_map children;

		bool is_leaf() { return branch_var == NULL_VAR; }
	};

private:
	void rec_delete(AI_Tree_Node* cn);
	AI_Tree_Node* next(AI_Tree_Node* cn, AI_SearchHeuristic* sh, AI_StateInspector* si);

	AI_Tree_Node* _root;
	LogicPlayer* _player;
};
