#pragma once
#include "GameData.h"
#include "LogicPlayer.h"
#include "AI_StateInspector.h"

class AI_StateInspector_Impl :	public AI_StateInspector
{
public:
	AI_StateInspector_Impl(GameData* data, int pnum);
	~AI_StateInspector_Impl() {}

	STATE_VALUE get_state_var(STATE_VAR_ID sid);
	void get_state(AI_State& state);
	void reset() { _prev_player_score = _prev_opponent_score = 0; }
	void end_ai_step();

	STATE_VALUE get_distance();
	STATE_VALUE get_current_move();
	STATE_VALUE get_obj_delta();
	STATE_VALUE get_user_move_choice();
	STATE_VALUE get_user_reinforcement();
	
private:
	GameData* _data;
	int _pnum;
	int _opnum;
	LogicPlayer* _player;
	LogicPlayer* _opponent;
	double _prev_player_score;
	double _prev_opponent_score;
};
