#include "AI_StateInspector_Impl.h"

AI_StateInspector_Impl::AI_StateInspector_Impl(GameData* data, int pnum): AI_StateInspector(si_standard),
	_data(data), _pnum(pnum), _opnum(1-pnum), _prev_player_score(0), _prev_opponent_score(0)
{ 
	_player = _data->_players[_pnum];
	_opponent = _data->_players[_opnum];
}

void AI_StateInspector_Impl::get_state(AI_State& state)
{
	AI_SearchHeuristic* sh = _player->_search_heuristic;

	while (sh->branch_var() != NULL_VAR)
	{
		double sv = get_state_var(sh->branch_var());
		state.push_back(sv);
		sh->next(sv);
	}
}

void AI_StateInspector_Impl::end_ai_step()
{
	_prev_player_score = _data->_match.get_score(_pnum);
	_prev_opponent_score = _data->_match.get_score(_opnum);
}

STATE_VALUE AI_StateInspector_Impl::get_state_var(STATE_VAR_ID sid)
{
	switch(sid)
	{
		case DISTANCE:
			return get_distance();
		case CURRENT_MOVE:
			return get_current_move();
		case OBJ_DELTA:
			return get_obj_delta();
		case USER_MOVE_CHOICE:
			return get_user_move_choice();
		case USER_REINFORCEMENT:
			return get_user_reinforcement();
		default:
			error("SERIOUS", "INVALID STATE_VAR_ID!", 1);
			break;
	}
}

STATE_VALUE AI_StateInspector_Impl::get_distance()
{
	Vector3 v = _player->_physics_player->frame().translation - _opponent->_physics_player->frame().translation;
	v.y = 0;
	return v.magnitude();
}

STATE_VALUE AI_StateInspector_Impl::get_current_move()
{
	return _player->_ai_player->current_move();
}

STATE_VALUE AI_StateInspector_Impl::get_obj_delta()
{
	int cur_obj = _data->_match.get_score(_pnum) - _data->_match.get_score(_opnum);
	int prev_obj = _prev_player_score - _prev_opponent_score;
	return cur_obj - prev_obj;
}

STATE_VALUE AI_StateInspector_Impl::get_user_move_choice()
{
	return _data->_input.user_command(_pnum);
}

STATE_VALUE AI_StateInspector_Impl::get_user_reinforcement()
{
	return _data->_input.user_reinforcement(_pnum);
}