#pragma once
#include "AI_Globals.h"

class AI_StateInspector
{
public:
	AI_StateInspector(AI_StateInspector_Type t): _type(t) {}
	virtual ~AI_StateInspector() {};

	virtual STATE_VALUE get_state_var(STATE_VAR_ID sid) = 0;
	virtual void get_state(AI_State& state) = 0;
	virtual void end_ai_step() = 0;
	virtual void reset() = 0;

	AI_StateInspector_Type type() { return _type; }

protected:
	AI_StateInspector_Type _type;
};
