#pragma once
#include "AI_Globals.h"

class AI_SearchHeuristic
{
public:
	AI_SearchHeuristic(AI_SearchHeuristic_Type t): _type(t) {}
	virtual ~AI_SearchHeuristic() {};

	virtual void begin_traversal() = 0;
	virtual void next(STATE_VALUE sv) = 0;
	virtual STATE_VAR_ID branch_var() = 0;
	virtual void initial_heuristic(MQV_Map& mqv_map) = 0;
	virtual bool at_end() = 0;

	AI_SearchHeuristic_Type type() { return _type; }

protected:
	AI_SearchHeuristic_Type _type;
};
