#pragma once
#include "AI_Globals.h"

class AI_QValues
{
public:
	AI_QValues(AI_QValues_Type t): _type(t) {}
	virtual ~AI_QValues() {};

	virtual MQV_Map& get_qvalues() = 0;
	virtual void update_qvalue(const AI_State& state, MOVE_ID move, double nq) = 0;
	virtual void load(PLAYER_ID pid) = 0;
	virtual void save(PLAYER_ID pid) = 0;
	virtual void clear() = 0;

	AI_QValues_Type type() { return _type; }

protected:
	AI_QValues_Type _type;
};
