#pragma once
#include "AI_Globals.h"

class AI_Player
{
	public:
	AI_Player(AI_Player_Type t) : _type(t) { }
	virtual ~AI_Player() {};

	virtual MOVE_ID calculate_next_move() = 0;
	virtual MOVE_ID current_move() = 0;
	virtual void reset() = 0;
	
	AI_Player_Type type() { return _type; }

	protected:
	AI_Player_Type _type;
};