#pragma once

#include <map>
#include <vector>
#include "llist.h"
#include "Globals.h"

enum AI_StateInspector_Type { si_standard=0 };
enum AI_QValues_Type { qv_standard=0 };
enum AI_Player_Type { p_standard=0 };
enum AI_SearchHeuristic_Type { sh_array=0 };

typedef std::vector<STATE_VALUE> AI_State;

struct History_Info
{
	History_Info(MOVE_ID m): move(m), obj_delta(0) { } 

	MOVE_ID move;
	AI_State state;
	double obj_delta;
};

typedef llist<History_Info*> AI_History;
typedef AI_History::iterator hist_iter;
typedef std::map<MOVE_ID, double> MQV_Map;
typedef MQV_Map::iterator MQV_iter;

// state vars
#define NULL_VAR -1
#define DISTANCE 0
#define CURRENT_MOVE 1
#define OBJ_DELTA 2
#define USER_MOVE_CHOICE 3
#define USER_REINFORCEMENT 4

struct StateVarInfo
{
	const char* name;
	double minimum_value;
	double maximum_value;
	double resolution;
};

extern StateVarInfo STATE_VARS[];
int state_value_to_index(STATE_VAR_ID sid, STATE_VALUE sv);



