#include "AI_Globals.h"

int state_value_to_index(STATE_VAR_ID sid, STATE_VALUE sv)
{
	if (sv < STATE_VARS[sid].minimum_value)
		sv = STATE_VARS[sid].minimum_value;
	else if (sv > STATE_VARS[sid].maximum_value)
		sv = STATE_VARS[sid].maximum_value;

	return floor((sv - STATE_VARS[sid].minimum_value) / STATE_VARS[sid].resolution);
}

StateVarInfo STATE_VARS[] = {
	{ "DISTANCE", 0, 0, 0 },
	{ "CURRENT_MOVE", 0, INT_MAX, 1 },
	{ "OBJ_DELTA", 0, INT_MAX, 1 },
	{ "USER_MOVE_CHOICE", 0, INT_MAX, 1 },
	{ "USER_REINFORCEMENT", -INT_MAX, INT_MAX, 1 }
};