#pragma once
#include "AI_SearchHeuristic.h"

class AI_ArrayHeuristic: public AI_SearchHeuristic
{
public:
	AI_ArrayHeuristic() : AI_SearchHeuristic(sh_array), _index(0) {}
	~AI_ArrayHeuristic() {}
	
	void begin_traversal() { _index = 0; }
	void next(STATE_VALUE sv) { _index++; }
	STATE_VAR_ID branch_var() { return _branch_vars[_index]; }
	bool at_end() { return _index+1 == _branch_vars.size(); }
	void initial_heuristic(MQV_Map& mqv_map) {};
	void set_branch_vars(const std::vector<STATE_VAR_ID>& bv) { _branch_vars.resize(bv.size()); 
													copy(bv.begin(), bv.end(), _branch_vars.begin()); }

private:
	std::vector<STATE_VAR_ID> _branch_vars;
	int _index;
};
