#include <hash_map>

/* Get hash_map, which is an extension to STL.
   In gcc before 3.2 we're fine with the #include; 3.3 and later
   put hash_map into the __gnu_cxx namespace. */
#ifdef HAVE_HASH_MAP
# include <hash_map>
namespace hashers {
  using stdext::hash_map;
//  using stdext::hash;
};
#elif HAVE_GNU_HASH_MAP
# include <ext/hash_map>
namespace hashers {
  using __gnu_cxx::hash_map;
//  using __gnu_cxx::hash;
};
#else
# error "no hash_map found!"
#endif
