#ifndef HASH_CLASSES_H
#define HASH_CLASSES_H

template<class Tuple>
class TupleHasher{
public:
    size_t operator()(const Tuple& t) const{
        return size_t( 997*(unsigned(t.v) >> 2) + 389*(unsigned(t.e) >> 2) + 773*(unsigned(t.f) >> 2) );
    }
};

template<class CellA, class CellB>
class PairHasher{
public:
    size_t operator()(const std::pair<CellA,CellB> &p) const {
        return size_t( 997*(unsigned(p.first) >> 2) + 389*(unsigned(p.second) >> 2) );
    }
};

/* Use the cast operator to generate a hash function. */
template<class T>
struct CastHash {
  unsigned long operator()(const T& t) const {
    return (unsigned long)t;
  }
};

#endif /* HASH_CLASSES_H */
