#include <time.h>
#include <sphelper.h>
#include <windows.h>

#include "GUI_App.h"
#include "dojo/dojo.h"
#include "ui/ui.h"
#include "dojo/physicsunits.h"
#include "App.h"

#define NUM_TIME_CHOICES 4
#define NUM_ROUNDS_CHOICES 3

const wxString TIME_CHOICES[] = {"1 min", "2 min", "5 min", "Unlimited"};
const wxString ROUNDS_CHOICES[] = {"1", "3", "5"};

class ChoiceDialog: public wxDialog
{
   public:
    ChoiceDialog
     ( wxWindow *parent, wxWindowID id, wxString* choices, int num_choices,
       const wxPoint& pos = wxDefaultPosition) : 
			wxDialog(parent, id, "CREATE MATCH", pos, wxSize(420, 180), wxCAPTION)
	{
		wxStaticText* p1_text = new wxStaticText(this, -1, "Player 1", wxPoint(10, 10), wxDefaultSize, 0);
		p1_select = new wxChoice(this, 301, wxPoint(5, 30), wxSize(190, 0), num_choices, choices, 0, wxDefaultValidator);

		wxStaticText* p2_text = new wxStaticText(this, -1, "Player 2", wxPoint(230, 10), wxDefaultSize, 0);
		p2_select = new wxChoice(this, 302, wxPoint(220, 30), wxSize(190, 0), num_choices, choices, 0, wxDefaultValidator);

		wxStaticText* round_text = new wxStaticText(this, -1, "Best Of", wxPoint(10, 60), wxDefaultSize, 0);
		rounds_select = new wxChoice(this, 302, wxPoint(5, 80), wxSize(190, 0), NUM_ROUNDS_CHOICES, ROUNDS_CHOICES, 0, wxDefaultValidator);
		rounds_select->SetSelection(1);

		wxStaticText* time_text = new wxStaticText(this, -1, "Round Length", wxPoint(230, 60), wxDefaultSize, 0);
		time_select = new wxChoice(this, 301, wxPoint(220, 80), wxSize(190, 0), NUM_TIME_CHOICES, TIME_CHOICES, 0, wxDefaultValidator);
		time_select->SetSelection(1);


		wxButton * ok = new wxButton( this, wxID_OK, "OK", wxPoint(130, 110), wxDefaultSize);
		wxButton * cancel = new wxButton( this, wxID_CANCEL, "CANCEL", wxPoint(210, 110), wxDefaultSize);
	}

    wxChoice* p1_select;
	wxChoice* p2_select;
	wxChoice* time_select;
	wxChoice* rounds_select;

   private:
	void OnOk( wxCommandEvent &event ) 
	{
		if (p1_select->GetSelection() != p2_select->GetSelection() && p1_select->GetSelection() != -1 && p2_select->GetSelection() != -1)
		{
			EndModal(wxID_OK);
		}
		else
		{
			wxMessageDialog msg(this, "Please choose different players.", "Message box", wxOK, wxDefaultPosition);
			msg.ShowModal();
		}
	}

	void OnCancel( wxCommandEvent &event)
	{
		EndModal(wxID_CANCEL);
	}

    DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE(ChoiceDialog, wxDialog)
EVT_BUTTON(wxID_OK, ChoiceDialog::OnOk)
EVT_BUTTON(wxID_CANCEL, ChoiceDialog::OnCancel)
END_EVENT_TABLE()

IMPLEMENT_APP_CONSOLE(GUI_App)

bool GUI_App::ProcessIdle()
{	
	static bool already_called = false;

	if (do_select_match && !already_called)
	{
		already_called = true;
		ChoiceDialog choice(0, -1, availPlayers, numPlayers, wxDefaultPosition);
		selectStatus = choice.ShowModal();
		if (selectStatus == wxID_OK)
		{
			P1Index = choice.p1_select->GetSelection();
			P2Index = choice.p2_select->GetSelection();
			
			switch (choice.rounds_select->GetSelection())
			{
				case 0:
					numRounds = 1;
					break;
				case 1:
					numRounds = 3;
					break;
				case 2:
					numRounds = 5;
					break;
			}

			switch (choice.time_select->GetSelection())
			{
				case 0:
					roundLength = 60;
					break;
				case 1:
					roundLength = 120;
					break;
				case 2:
					roundLength = 300;
					break;
				case 3:
					roundLength = -1;
					break;
			}
		}
		do_select_match = false;
		selection_done = true;
		already_called = false;
	}

	return wxAppBase::ProcessIdle();
}

bool GUI_App::OnInit()
{	
	if ( SUCCEEDED( CoInitialize( NULL ) ) )
    {
		srand(time(NULL));

		GAppSettings settings;
	    
		settings.useNetwork = false;
		settings.window.stencilBits = 8;
		settings.window.alphaBits = 0;
		settings.window.fsaaSamples = 4;
	    
		if (! fileExists("grid.png")) {
			// For running under visual studio
			_chdir("../../build");
		}

		alwaysAssertM(fileExists("grid.png"),
			"Project cannot find its data files.");
		
		wxFrame* frame = new wxFrame(0, -1, "KUNG FOO", wxPoint(0, 0), wxSize(820, 650), wxDEFAULT_FRAME_STYLE);

		SetTopWindow(frame);

		gwindow = new wxGWindow( GWindowSettings(), frame, -1 );
		dojo::app = new App(settings, this);
				
		dojo::app->run();

		frame->Show();
		gwindow->wxHandle()->Show();	

		debugAssert(dojo::app->debugFont.notNull());

		return TRUE;
	}
	else 
		error("SERIOUS", "CAN'T COINITIALIZE!", true);

	return 0;
}

int GUI_App::OnExit()
{
	delete dojo::app;
	dojo::app = NULL;

	DeletePendingObjects();
	CoUninitialize();

	return 0;
}