#pragma once
#include "Globals.h"
#include "ui/ui.h"

class Match
{
public:

	//Two constructors - aren't actually called
	Match(class GameData* game);
	Match(float round_length, class GameData* game);
	
	//Accessor/Mutator for the timer
	float get_round_length() { return round_length; }
	void set_round_length(float ml) { round_length = ml; }
	
	//Accessor/Mutator for a player's score
	int get_score(int pnum) { return score[pnum]; }
	void incr_score(int pnum, int delta) { score[pnum] += delta; }

	//Accessor/Mutator for a player's health
	void decr_health(int pnum, int delta);
	int get_health(int pnum);

	//Called in simulation (in Demo) to get current status of the timer
	void update_timer(float delta);

	//Manages the round information
	void set_max_rounds(int num) { max_rounds = num; current_round = 0; }
	bool start_next_round();

	//Returns status of current round (looks at timer and players' health)
	bool check_round_over();
	int get_winner(); // WHO WON?
	bool do_end_of_round(); // MOVED PROCESSING FROM START_NEXT_ROUND TO HERE
	
	//Checks to see if the current game is complete (when the number of rounds > max rounds)
	bool check_game_over(){ return game_over; }

	//Returns the number of wins of a player
	int get_num_wins(int pnum);

	//Returns the current status of the timer
	float get_time_left();
	
	//Don't need to call this - reset takes care of it
	void start();

	//Gives players full health, returns the timer to it original state, and sets the number of rounds to 0
	void reset();

	//Loads in all the textures for the gui
	void load_textures();

	//These actually display the relavent information on the screen (player's health, timer, rounds)
	void display_hud(RenderDevice* rd, GameUI* gui);
	void display_number(RenderDevice* rd, int num, int xCoord, int yCoord, int size);

	void display_tie(RenderDevice* rd);
	void display_player_win_round(RenderDevice* rd, int pnum);

	void display_player_win_match(RenderDevice* rd, int pnum);

	void display_loadscreen(RenderDevice* rd);
	void display_helpscreen(RenderDevice* rd);


private:
	int score[2];
	int health[2];
	int numWins[2];
	float round_length;
	float time_left;

	int current_round;
	int max_rounds;

	class GameData* game;

	bool game_over;

	Array<TextureRef>		tr_numbers;

	TextureRef				tr_colon;
	TextureRef				tr_slash;

	TextureRef				tr_bar_background;
	TextureRef				tr_red_bar;
	TextureRef				tr_yellow_bar;
	TextureRef				tr_green_bar;
	
	TextureRef				tr_round;
	TextureRef				tr_time;

	TextureRef				tr_rounds_won;
	TextureRef				tr_player1_win_round;
	TextureRef				tr_player2_win_round;
	TextureRef				tr_tie_game;

	TextureRef				tr_player1_win_match;
	TextureRef				tr_player2_win_match;

	TextureRef				tr_next_round;
	TextureRef				tr_next_match;

	TextureRef				tr_loadscreen;
	TextureRef				tr_helpscreen;
	
};
