#include "Match.h"
#include "GameData.h"
#include <time.h>


Match::Match(GameData* _game)
{ 
	Match(0, _game);	
}

Match::Match(float round_length, GameData* _game): game(_game), round_length(round_length) 
{ 
	reset(); 
	max_rounds = 3;
}


void Match::load_textures()
{
	//Load the numbers
	for(int i = 0; i < 10; i++)
	{
		char textureName[256];
		sprintf(textureName, "images\\numbers\\%d.jpg", i);

		tr_numbers.append( Texture::fromTwoFiles(textureName, textureName, TextureFormat::RGBA8, Texture::CLAMP) );
	}

	//Load the colon
	tr_colon = Texture::fromTwoFiles("images\\numbers\\colon.jpg", "images\\numbers\\colon.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//The "time" tag
	tr_time = Texture::fromTwoFiles("images\\text\\time.jpg", "images\\text\\time_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//Health bar background
	tr_bar_background = Texture::fromTwoFiles("images\\healthbar\\background.jpg", "images\\healthbar\\mask.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//The three colors
	tr_red_bar = Texture::fromTwoFiles("images\\healthbar\\red.jpg", "images\\healthbar\\mask.jpg", TextureFormat::RGBA8, Texture::CLAMP);
	tr_yellow_bar = Texture::fromTwoFiles("images\\healthbar\\yellow.jpg", "images\\healthbar\\mask.jpg", TextureFormat::RGBA8, Texture::CLAMP);
	tr_green_bar = Texture::fromTwoFiles("images\\healthbar\\green.jpg", "images\\healthbar\\mask.jpg", TextureFormat::RGBA8, Texture::CLAMP);


	//Rounds won by each player
	tr_rounds_won = Texture::fromTwoFiles("images\\text\\rounds_won.jpg", "images\\text\\rounds_won_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);


	//The "round" tag
	tr_round = Texture::fromTwoFiles("images\\text\\round.jpg", "images\\text\\round_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);


	//Slash
	tr_slash = Texture::fromTwoFiles("images\\numbers\\slash.jpg", "images\\numbers\\slash.jpg", TextureFormat::RGBA8, Texture::CLAMP);


	//Tie game splash
	tr_tie_game = Texture::fromTwoFiles("images\\text\\tie.jpg", "images\\text\\tie_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//Players win a round
	tr_player1_win_round = Texture::fromTwoFiles("images\\text\\player1_win_round.jpg", "images\\text\\player1_win_round_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);
	tr_player2_win_round = Texture::fromTwoFiles("images\\text\\player2_win_round.jpg", "images\\text\\player2_win_round_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);	

	//Tell the gamer to press "spacebar" after a round
	tr_next_round = Texture::fromTwoFiles("images\\text\\white.jpg", "images\\text\\next_round_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//Players win the match
	tr_player1_win_match = Texture::fromTwoFiles("images\\text\\player1_win_match.jpg", "images\\text\\player1_win_match_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);	
	tr_player2_win_match = Texture::fromTwoFiles("images\\text\\player2_win_match.jpg", "images\\text\\player2_win_match_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);	

	//Tell the gamer to press "enter" after match
	tr_next_match = Texture::fromTwoFiles("images\\text\\white.jpg", "images\\text\\next_match_alpha.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//Splashscreen
	tr_loadscreen = Texture::fromFile("images\\background\\startup.jpg", TextureFormat::RGBA8, Texture::CLAMP);

	//Help menu
	tr_helpscreen = Texture::fromFile("images\\text\\help.jpg", TextureFormat::RGBA8, Texture::CLAMP);
}

float Match::get_time_left() 
{ 
	return time_left;
}

void Match::reset()
{
	score[0] = score[1] = 0;
	health[0] = health[1] = 100;
	numWins[0] = numWins[1] = 0;
	time_left = (round_length != -1 ? round_length : 0);
	game_over = false;

}

void Match::update_timer(float delta) 
{ 
	if (round_length != -1)
		time_left -= delta; 
}

void Match::display_hud(RenderDevice* rd, GameUI* gui)
{
	//Display text: "Time:"
    rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_time);
	Draw::rect2D(Rect2D::xywh(372, 4, 56, 20), rd);


	//Display time left
	int tempTime = (int)time_left;

	if(tempTime > 600)
	{
		tempTime = 600;
	}
	else if (tempTime < 0)
	{
		tempTime = 0;
	}

	int minutes = tempTime / 60;
	int seconds = tempTime % 60;

	int startX = 360;
	int startY = 30;
	int size = 30;

	//Minutes
	display_number(rd, minutes, startX, startY, size);

	//Colon
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_colon);
	Draw::rect2D(Rect2D::xywh(startX + size/2, startY, size, size), rd);

	//Seconds
	if(seconds > 9)
	{
		int tensPlace = seconds / 10;
		int onesPlace = seconds % 10;

		display_number(rd, tensPlace, startX + size, startY, size);
		display_number(rd, onesPlace, startX + 1.6*size, startY, size);
	}
	else
	{
		display_number(rd, 0, startX + size, startY, size);
		display_number(rd, seconds, startX + 1.6*size, startY, size);
	}

	//Health bars

	//Player 1 background
	
	int player1_x = 10;

	int barYpos = 5;
	int barWidth = 300;
	int barHeight = 25;
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_bar_background);
	Draw::rect2D(Rect2D::xywh(player1_x, barYpos, barWidth, barHeight), rd);

	//Player1 health
	if(health[0] > 75)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_green_bar);
		Draw::rect2D(Rect2D::xywh(player1_x, barYpos, barWidth * (health[0]/100.0), barHeight), rd);
	}
	else if(health[0] > 25)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_yellow_bar);
		Draw::rect2D(Rect2D::xywh(player1_x, barYpos, barWidth * (health[0]/100.0), barHeight), rd);
	}
	else
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_red_bar);
		Draw::rect2D(Rect2D::xywh(player1_x, barYpos, barWidth * (health[0]/100.0), barHeight), rd);
	}

	//Number of rounds won by player 1
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_rounds_won);
	Draw::rect2D(Rect2D::xywh(200, 20, 80, 40), rd);
	
	display_number(rd, numWins[0], 275, 30, 20);

	//Player 2 background
	
	int player2_x = 790;

	barYpos = 5;
	barWidth = -300;
	barHeight = 25;

	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_bar_background);
	Draw::rect2D(Rect2D::xywh(player2_x, barYpos, barWidth, barHeight), rd);


	//Player2 health
	if(health[1] > 75)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_green_bar);
		Draw::rect2D(Rect2D::xywh(player2_x, barYpos, barWidth * (health[1]/100.0), barHeight), rd);
	}
	else if(health[1] > 25)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_yellow_bar);
		Draw::rect2D(Rect2D::xywh(player2_x, barYpos, barWidth * (health[1]/100.0), barHeight), rd);
	}
	else
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_red_bar);
		Draw::rect2D(Rect2D::xywh(player2_x, barYpos, barWidth * (health[1]/100.0), barHeight), rd);
	}

	//Number of rounds won by player 1
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_rounds_won);
	Draw::rect2D(Rect2D::xywh(520, 20, 80, 40), rd);
	
	display_number(rd, numWins[1], 595, 30, 20);

	//Round info
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_round);
	Draw::rect2D(Rect2D::xywh(10, 560, 100, 25), rd);
	
	//Current round
	display_number(rd, current_round + 1, 110, 560, 25);

	//slash
	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_slash);
	Draw::rect2D(Rect2D::xywh(130, 560, 25, 25), rd);

	//max rounds
	display_number(rd, max_rounds, 150, 560, 25);
}


void Match::display_number(RenderDevice* rd, int num, int xCoord, int yCoord, int size)
{
	if(num > 9 || num < 0)
		return ;


	rd->setAlphaTest(RenderDevice::ALPHA_GREATER, 0.5);
    rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_numbers[num]);
	Draw::rect2D(Rect2D::xywh(xCoord, yCoord, size, size), rd);
}


void Match::decr_health(int pnum, int delta)
{ 
	if(pnum > 1 || pnum < 0)
	{
		return;
	}

	health[pnum] = health[pnum]-delta; 

	if(health[pnum] < 0)
	{
		health[pnum] = 0;
	}
}

int Match::get_health(int pnum)
{
	if(pnum < 0 || pnum > 1)
	{
		return -1;
	}

	return health[pnum];
}

int Match::get_num_wins(int pnum)
{
	if(pnum < 0 || pnum > 1)
	{
		return -1;
	}

	return numWins[pnum];
}


void Match::start()
{
	current_round = 0;
	reset();
}

bool Match::start_next_round()
{
	if (game_over)
		return false;

	score[0] = score[1] = 0;
	health[0] = health[1] = 100;
	time_left = (round_length != -1 ? round_length : 0);

	return true;
}

// figure out whose won if anyone
int Match::get_winner()
{
	if(round_length != -1 && time_left < .01)
	{
		if(health[0] > health[1])
		{
			return 0;
		}
		else if (health[1] > health[0])
		{
			return 1;
		}
		else
		{
			return 2;
		}
	}
	else
	{
		if (health[0] == 0 && health[1] == 0)
		{
			return 2;
		}
		else if (health[0] == 0)
		{
			return 1;
		}
		else if (health[1] == 0)
		{
			return 0;
		}
		else
			return -1;
	}
}

bool Match::check_round_over()
{
	return get_winner() != -1;
}

bool Match::do_end_of_round()
{
	if (!check_round_over())
		return false;

	int winner = get_winner();

	// not a tie
	if (winner != 2) // IF IT IS A TIE, REPLAY THE ROUND (WE CAN CHANGE THIS)
	{
		if (++current_round >= max_rounds)
		{
			game_over = true;
			//This is so the display doesn't mess up (ie, Round 4 / 3)
			current_round = max_rounds-1;
		}
		numWins[winner]++;

		//if a player wins more than half the total possible rounds, then 
		//they win by default
		if(numWins[winner] > (max_rounds/2.0))
			game_over = true;
	}

	return true;
}

void Match::display_player_win_round(RenderDevice* rd, int pnum)
{

	if(pnum == 0)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_player1_win_round);
		Draw::rect2D(Rect2D::xywh(100, 150, 600, 225), rd);
	}
	else
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_player2_win_round);
		Draw::rect2D(Rect2D::xywh(100, 150, 600, 225), rd);
	}

	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_next_round);
	Draw::rect2D(Rect2D::xywh(200, 400, 400, 150), rd);
	
}

void Match::display_tie(RenderDevice* rd)
{

	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
    rd->setTexture(0, tr_tie_game);
	Draw::rect2D(Rect2D::xywh(200, 150, 400, 150), rd);


	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_next_round);
	Draw::rect2D(Rect2D::xywh(200, 400, 400, 150), rd);
}

void Match::display_player_win_match(G3D::RenderDevice *rd, int pnum)
{

	if(pnum == 0)
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_player1_win_match);
		Draw::rect2D(Rect2D::xywh(50, 100, 700, 280), rd);
	}
	else
	{
		rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
		rd->setTexture(0, tr_player2_win_match);
		Draw::rect2D(Rect2D::xywh(50, 100, 700, 280), rd);
	}

	rd->setBlendFunc(RenderDevice::BLEND_SRC_ALPHA, RenderDevice::BLEND_ONE_MINUS_SRC_ALPHA);
	rd->setTexture(0, tr_next_match);
	Draw::rect2D(Rect2D::xywh(200, 400, 400, 150), rd);
}

void Match::display_loadscreen(RenderDevice* rd)
{
	rd->setBlendFunc(RenderDevice::BLEND_ONE, RenderDevice::BLEND_ZERO);
	rd->setTexture(0, tr_loadscreen);
	Draw::rect2D(Rect2D::xywh(0, 0, 800, 600), rd);
}

void Match::display_helpscreen(RenderDevice* rd)
{
	rd->setBlendFunc(RenderDevice::BLEND_ONE, RenderDevice::BLEND_ZERO);
	rd->setTexture(0, tr_helpscreen);
	Draw::rect2D(Rect2D::xywh(0, 0, 800, 600), rd);
}