#pragma once
#include "dojo/Entity.h"

#include "AI_Globals.h"
#include "AI_Player.h"
#include "AI_QValues.h"
#include "AI_SearchHeuristic.h"
#include "AI_StateInspector.h"

using namespace dojo;

class LogicPlayer
{
public:
	LogicPlayer(class GameData* _game, int _pnum);
	~LogicPlayer();

	void load(PLAYER_ID player_id, Vector3 starting_pos);
	void save();
	void clear();

public:
	// basic info
	GameData* game;
	PLAYER_ID pid;
	std::string name;
	int pnum;

	// AI vars
	AI_StateInspector* state_inspector;
	AI_QValues* qvalues;
	AI_Player* ai_player;
	AI_SearchHeuristic* search_heuristic;
	AI_History* history;
	std::vector<MOVE_ID> moves;
	
	// Physics data
	EntityRef physics_player_ref;
	PhysicsPlayer* physics_player;
};

