#pragma once
#include <cassert>
#include <climits>
#include <sstream>
#include "dojo/dojo.h"

typedef char MOVE_ID;
typedef char STATE_VAR_ID;
typedef unsigned int PLAYER_ID;
typedef float STATE_VALUE;
typedef float AI_PARAM;

using namespace dojo;
typedef class Marionette PhysicsPlayer;

// standard move id's
#define NULL_MOVE -2
#define DEFAULT_STANCE -1

// string conversion operations
void string_to(const std::string& input, float& output);
void string_to(const std::string& input, double& output);
void string_to(const std::string& input, int& output);
void string_to(const std::string& input, unsigned int& output);
void string_to(const std::string& input, long& output);

void trim_string(std::string& str);
char *trim_string(char *string);

// bit operations
float bit_shizzle(float f, int nb);
double bit_shizzle(double d, int nb);

// Useful operators
template<class T>
struct delete_operator
{
	void operator() (T* x) { delete x; }
};

struct key_value
{
	key_value(const std::string& line)
	{
		std::istringstream buf(line);
		buf >> key;
		if (key[key.size()-1] == '=')
			key.erase(key.size()-1, 1);
		else
			buf.ignore(256,'=');
		
		getline(buf, value);
		trim_string(value);
	}

	std::string key, value;
};