#include "Globals.h"

void string_to(const std::string& input, float& output)
{
	output = atof(input.c_str());
}

void string_to(const std::string& input, double& output)
{
	output = atof(input.c_str());
}

void string_to(const std::string& input, int& output)
{
	output = atoi(input.c_str());
}

void string_to(const std::string& input, unsigned int& output)
{
	output = strtoul(input.c_str(),0,10);
}

void string_to(const std::string& input, long& output)
{
	output = atol(input.c_str());
}

double bit_shizzle(double d, int nb)
{
	unsigned long long* lrep = reinterpret_cast<unsigned long long*> (&d);
	*lrep >>= nb;
	*lrep <<= nb;
	return d;
}

float bit_shizzle(float f, int nb)
{
	unsigned long* lrep = reinterpret_cast<unsigned long*> (&f);
	*lrep >>= nb;
	*lrep <<= nb;
	return f;
}

void trim_string(std::string& str)
{
    if (str.empty())
    	return;

	int p = str.length()-1;

	while (p >= 0 && isspace(str[p])) 
		--p;
	
	if (p+1 < str.size())
		str.erase(p+1, str.size()-p-1);

	p = 0;

	if (str.empty())
		return;

	while (p < str.size() && isspace(str[p]))
    	++p;

	if (p > 0)
		str.erase(0, p);
}

char *trim_string(char *string)
/*********************************/
// Trims spaces off the front and end of strings.  Modifies the string.
// Specifically DOES allow string==NULL; returns NULL in that case.
{
    char *p;
    char *q;

    if (string == NULL)
    	return NULL;

    p = string;
    q = string + strlen(string) - 1;

    while (q >= p && isspace(*q))
    	*(q--) = 0;
    while (isspace(*p))
    	p++;

    return p;
}