#include "Demo.h"
#include "GameData.h"
#include "LogicPlayer.h"
#include "Marionette.h"
#include "Match.h"
#include "KUserInput.h"

GameData::GameData(Demo* _demo) : demo(_demo), match(this)
{
	players[0] = new LogicPlayer(this, 0);
	players[1] = new LogicPlayer(this, 1);
}

GameData::~GameData()
{
	delete players[0];
	delete players[1];
}

void GameData::save_players()
{
	players[0]->save();
	players[1]->save();
}

void GameData::load(PLAYER_ID p1, PLAYER_ID p2)
{
	players[0]->clear();
	players[1]->clear();

	players[0]->load(p1, demo->playerStartPosition(0));
	players[1]->load(p2, demo->playerStartPosition(1));

	/*
	for (int i=0; i < 2; i++)
	{
		LogicPlayer* p = players[i];
		input.give_command(i, 0);
		p->state_inspector->end_ai_step();
		p->ai_player->calculate_next_move();
		p->state_inspector->end_ai_step();
	}
	*/

	input.reset();

	players[0]->physics_player->setOpponent(players[1]->physics_player);
	players[1]->physics_player->setOpponent(players[0]->physics_player);

	players[0]->physics_player->initPullPoints(players[0]->physics_player->frame());
	players[1]->physics_player->initPullPoints(players[1]->physics_player->frame());
}

STATE_VALUE GameData::get_state_value(int pnum, const std::string& name, bool constrain)
{
	return players[pnum]->state_inspector->get_state_value(name, constrain);
}