#pragma once
#include "dojo/dojo.h"
#include "ui/ui.h"
#include "AI_Globals.h"
#include "Globals.h"

using namespace dojo;

struct name_id_pair
{
	name_id_pair(): name(""), id(-1) {}
	name_id_pair(const std::string& _name, int _id) : name(_name), id(_id) {}
	std::string name;
	PLAYER_ID id;
};

class Demo : public DApplet {
public:
	
	//the main player in the game.  In this case, a ball
 	PhysicsPlayer*		player;
	PhysicsPlayer*		enemy;
	class GameData*		game;

	bool				check_time;
	float				time_left;
	int					num_chosen;
	
	Array<UIHandle>		move_handles;
	Array<char*>		move_list;
	UIHandle			red_text;

	std::vector<name_id_pair> avail_players;
	class wxString*		avail_player_names;

	class AI_Player*	ai_player;
	class AI_Player*	ai_enemy;

	// GUI_App
	class GUI_App*		gui_app;

	int					cur_players[2];

	// when the ai thinks
	bool				ai_timed_decisions;
	int					ai_cycle_pos;
	int					ai_cycle_len;

	// save q-values every 30 seconds
	double				save_time;

	// has we started a match
	bool				match_going;
	bool				round_going;

	// what to display
	int					display_code;
	int					prev_code;

    // Add state that should be visible to this applet.
    // If you have multiple applets that need to share
    // state, put it in the App.

    TextureRef          logo;

    class App*          app;

	//the position in the worlds to spawn the player
	Vector3				spawnPosition;

	//used to record the position of the player in the previous frame.  used to
	//calculate camera position
	Vector3				previousPlayerPosition;

	//pointer to a GameUI to allow for UI Sprites, text etc.
	GameUI*				gameUI;

	//handle to the score text in the GameUI
	UIHandle			scoreHandle;
	UIHandle			deathHandle;

	UIHandle			player1_name;
	UIHandle			player2_name;

	//counter of the current score
	//int gameScore;
	
	//pureDeltaMouse is a bool signifying if the camera is in mouse look mode
	bool pureDeltaMouse;

	void incrementGameScore(int amt, int pnum);
	
	void load_available_players();

	void start_new_match(int p1, int p2, int num_rounds, int round_length);
	void start_next_round();
	void return_to_previous();
	void toggle_help();

	Vector3 playerStartPosition(int i);

	Demo(App* app);

    virtual ~Demo();

    virtual void onInit();

    virtual void onLogic();

    virtual void onUserInput(UserInput*);

	virtual void onNetwork();

    virtual void onSimulation(RealTime rdt, SimTime sdt, SimTime idt);

    virtual void onGraphics(RenderDevice* rd);

    virtual void onCleanup();

	// speech recognition functions
	HRESULT setup_player_commands();

	static HRESULT init_sapi();
	static void cleanup_sapi();
	
	static LRESULT CALLBACK Reco_Event(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	void ExecuteCommand(struct ISpPhrase *pPhrase);

	void handleSelection(int move);
};
