#include "Ball.h"
#include "Demo.h"

using namespace dojo;

EntityRef Ball::create(const std::string& name, Demo* demo) {
    static ArticulatedModelRef body = ArticulatedModel::fromFile("sphere.ifs", 1.0f/3.0f);
    static bool initialized = false;

    if (! initialized) {
        SuperShader::Material material;
		material.diffuse.constant = Color3::yellow() / 2;
        //material.diffuse.map   = Texture::fromFile("basketball.jpg");
        
        material.emit      = Color3::black();
        material.transmit  = Color3::black();
        material.reflect   = Color3::black();
        material.specular  = Color3::white() * .5f;
        material.specularExponent = Color3::white() * 40;

        body->partArray.last().triListArray[0].material = material;
        body->updateAll();
        initialized = true;
    }

    Ball* c = new Ball(name, demo);

    c->addGraphicsGeometry("Root", body);

    // Note that the mass is not being transformed with the collision geometry!
	c->addPhysicsGeometry(
        "Root",
        new SphereShape(Sphere(Vector3::zero(), 1.0f/3.0f)),
        30);
        
    return EntityRef(c);
}

//this is first defined in Dojo::Entity
bool Ball::onCollision(const std::string&  myPart, 
					const EntityRef&    other, 
					const std::string&  otherPart,
					const Vector3&      wsLocation)	{

	if (other->name() == "PLAYER1")
		demo->incrementGameScore(10,0);

	return true;
}

void Ball::move(int direction)
{
	Vector3 roll_dir = velocity("Root");
	if (roll_dir.isZero()) 
		roll_dir = frame().lookVector();
	roll_dir = Matrix3::fromAxisAngle(Vector3(0,1,0), direction*(M_PI/4)) * roll_dir.unit() * 20;
	applyForce("Root", roll_dir);
}