#include "GUI_App.h"
#include "App.h"
#include "Demo.h"
#include "Ball.h"

void App::loadScene() {
    World* world = World::world();

    world->init();

    Log::common()->printf("begin loadScene\n");

    world->sky = Sky::create(NULL, app->dataDir + "sky/");

	//initialize the scene with a sky box etc.
    world->lighting = Lighting::create();
    {
        LightingRef lighting = world->lighting;
        world->skyParameters = LightingParameters(G3D::toSeconds(10, 00, 00, AM));
    
        world->skyParameters.skyAmbient = Color3::white();

        if (world->sky.notNull()) {
            world->lighting->environmentMap = world->sky->getEnvironmentMap();
            world->lighting->environmentMapColor = world->skyParameters.skyAmbient;
        } else {
            world->lighting->environmentMapColor = Color3::black();
        }

        Color3 top = Color3(0.6f, 0.6f, 1.0f) * world->skyParameters.diffuseAmbient;
        debugAssert(lighting.notNull());
        lighting->ambientTop = top;
        world->lighting->ambientBottom = Color3::white() * .4f;

        world->lighting->emissiveScale = world->skyParameters.emissiveScale;

        world->lighting->lightArray.clear();

        world->lighting->shadowedLightArray.clear();

        GLight L = world->skyParameters.directionalLight();
        // Decrease the blue since we're adding blue ambient
        L.color *= Color3(1, 1, 0.9f);
        L.position = Vector4(Vector3(0,1,1).direction(), 0);

        world->lighting->shadowedLightArray.append(L);

    }

    Log::common()->printf("  objects\n");

	//insert a ground plane into the world
    //world->insert(GroundPlane::create(), Vector3(0,-6.01f, 0));

	//load the map specified
	Q3Map* map = Q3Map::create("Map", "./", "dojo.bsp");

	//insert the map into teh world
	world->insert((EntityRef)map, CoordinateFrame());

	//let the appler know about the spawn point
	applet->spawnPosition = map->startingPosition();
	applet->previousPlayerPosition = map->startingPosition();
	
	//set the initial value for gravity
    world->setGravity(Vector3(0, -9.81f, 0));
    Log::common()->printf("end loadScene\n");
}


App::App(const GAppSettings& settings, GUI_App* _gui_app) : DApp(settings, _gui_app->gwindow), gui_app(_gui_app) {
    window()->setCaption("AI TEST"); 
    applet = new Demo(this);
    setApplet(applet);
}


App::~App() {
    delete applet;
    applet = NULL;
}

App* app = NULL;


void App::main() {
	setDebugMode(true);

    if (GLCaps::renderer() == "GDI Generic") {
        G3D::msgBox(
            "This machine has no OpenGL driver.  "
            "Please download and install the correct driver.  "
            "(Maybe from nvidia.com or ati.com?)", 
            "Video Error");
        exit(-1);
    }

    loadScene();
    //World::world()->renderMode = World::RENDER_PHYSICS;

    applet->run();
}

