#pragma once
#include "AI_Globals.h"

class AI_StateInspector
{
public:
	AI_StateInspector(AI_StateInspector_Type t): _type(t) {}
	virtual ~AI_StateInspector() {};

	virtual STATE_VAR_ID get_state_id(const std::string& name) = 0;
	virtual std::string get_state_name(STATE_VAR_ID sid) = 0;
	virtual state_var_info& get_state_info(const std::string& name) = 0;
	virtual state_var_info& get_state_info(STATE_VAR_ID sid) = 0;
	virtual STATE_VALUE get_state_value(const std::string& name, bool constrain=true) = 0;
	virtual STATE_VALUE get_state_value(STATE_VAR_ID sid, bool constrain=true) = 0;
	virtual void get_state(AI_State& state, bool constrain=true) = 0;

	virtual void end_ai_step() = 0;
	virtual void load(PLAYER_ID pid) = 0;
	
	AI_StateInspector_Type type() { return _type; }

protected:
	AI_StateInspector_Type _type;
};
